﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_FND_FILE_H_
#define NW_SND_FND_FILE_H_

#include <nw/types.h>

#if defined(NW_PLATFORM_CAFE)
#include <cafe/fs.h>
#endif

#include <nw/snd/fnd/basis/sndfnd_Config.h>
#include <nw/snd/fnd/basis/sndfnd_Result.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

class FileStream;

//---------------------------------------------------------------------------
//! @brief  ファイル特性です。
//---------------------------------------------------------------------------
class FileTraits
{
public: // 定数
#if defined(NW_PLATFORM_CAFE)
    static const u32 IO_BUFFER_ALIGNMENT = FS_IO_BUFFER_ALIGN;
#else
    static const u32 IO_BUFFER_ALIGNMENT = 1;
#endif
};

//---------------------------------------------------------------------------
//! @brief  ファイルを操作するクラスです。
//---------------------------------------------------------------------------
class File
{
public: // 型の定義
    enum AccessMode
    {
        ACCESS_MODE_NONE,
        ACCESS_MODE_READ = 1 << 0,
        ACCESS_MODE_WRITE = 1 << 1,
        ACCESS_MODE_READ_AND_WRITE = ACCESS_MODE_READ | ACCESS_MODE_WRITE
    };

private: // コンストラクタ
    File() {}

public: // メソッド
#if defined(NW_PLATFORM_CAFE)
    static FndResult Open(
        FileStream* stream,
        FSClient* fsClient,
        FSCmdBlock* fsCmdBlock,
        const char* filePath,
        AccessMode accessMode);
#elif defined(NW_PLATFORM_CTR) || defined(NW_PLATFORM_WIN32) || defined(NW_PLATFORM_ANDROID)
    static FndResult Open(FileStream* stream, const char* filePath, AccessMode accessMode);
#elif defined(NW_USE_NINTENDO_SDK)
    static FndResult Open(FileStream* stream, const char* filePath, AccessMode accessMode);
#endif
};

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_FND_FILE_H_
