﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_FND_PRIMITIVE_TYPES_H_
#define NW_SND_FND_PRIMITIVE_TYPES_H_

#include <nw/snd/fnd/basis/sndfnd_Config.h>
#include <nw/snd/fnd/basis/sndfnd_Endian.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
// ターゲット向け数値型の定義
//---------------------------------------------------------------------------
#if defined(NW_SND_FND_SHOULD_REVERSE_ENDIAN)

// 実機向け数値へのアクセサ
typedef bool                          BinBool;
typedef u8                            BinU8;
typedef s8                            BinS8;
typedef endian::ReverseEndianNum<u16> BinU16;
typedef endian::ReverseEndianNum<s16> BinS16;
typedef endian::ReverseEndianNum<u32> BinU32;
typedef endian::ReverseEndianNum<s32> BinS32;
typedef endian::ReverseEndianNum<f32> BinF32;
typedef endian::ReverseEndianNum<u64> BinU64;
typedef endian::ReverseEndianNum<s64> BinS64;
typedef endian::ReverseEndianNum<f64> BinF64;

#else

// 実機向け数値へのアクセサ
typedef bool BinBool;
typedef u8   BinU8;
typedef s8   BinS8;
typedef u16  BinU16;
typedef s16  BinS16;
typedef u32  BinU32;
typedef s32  BinS32;
typedef f32  BinF32;
typedef u32  BinU64;
typedef s32  BinS64;
typedef f64  BinF64;

#endif // NW_SND_FND_SHOULD_REVERSE_ENDIAN

//---------------------------------------------------------------------------
// PC向け数値型の定義
// 実行環境が BIG_ENDIAN ならエンディアン変換を有効化する
//---------------------------------------------------------------------------
#if defined(NW_SND_FND_IS_LITTLE_ENDIAN)

// PC 上のリトルエンディアン数値へのアクセサ
typedef bool PcBinBool;
typedef u8   PcBinU8;
typedef s8   PcBinS8;
typedef u16  PcBinU16;
typedef s16  PcBinS16;
typedef u32  PcBinU32;
typedef s32  PcBinS32;
typedef f32  PcBinF32;
typedef u32  PcBinU64;
typedef s32  PcBinS64;
typedef f64  PcBinF64;

// PC 上のビッグエンディアン数値へのアクセサ
typedef bool                          PcBeBinBool;
typedef u8                            PcBeBinU8;
typedef s8                            PcBeBinS8;
typedef endian::ReverseEndianNum<u16> PcBeBinU16;
typedef endian::ReverseEndianNum<s16> PcBeBinS16;
typedef endian::ReverseEndianNum<u32> PcBeBinU32;
typedef endian::ReverseEndianNum<s32> PcBeBinS32;
typedef endian::ReverseEndianNum<f32> PcBeBinF32;
typedef endian::ReverseEndianNum<u64> PcBeBinU64;
typedef endian::ReverseEndianNum<s64> PcBeBinS64;
typedef endian::ReverseEndianNum<f64> PcBeBinF64;

#else

// PC 上のリトルエンディアン数値へのアクセサ
typedef bool                          PcBinBool;
typedef u8                            PcBinU8;
typedef s8                            PcBinS8;
typedef endian::ReverseEndianNum<u16> PcBinU16;
typedef endian::ReverseEndianNum<s16> PcBinS16;
typedef endian::ReverseEndianNum<u32> PcBinU32;
typedef endian::ReverseEndianNum<s32> PcBinS32;
typedef endian::ReverseEndianNum<f32> PcBinF32;
typedef endian::ReverseEndianNum<u64> PcBinU64;
typedef endian::ReverseEndianNum<s64> PcBinS64;
typedef endian::ReverseEndianNum<f64> PcBinF64;

// PC 上のビッグエンディアン数値へのアクセサ
typedef bool PcBeBinBool;
typedef u8   PcBeBinU8;
typedef s8   PcBeBinS8;
typedef u16  PcBeBinU16;
typedef s16  PcBeBinS16;
typedef u32  PcBeBinU32;
typedef s32  PcBeBinS32;
typedef f32  PcBeBinF32;
typedef u32  PcBeBinU64;
typedef s32  PcBeBinS64;
typedef f64  PcBeBinF64;

#endif // NW_SND_FND_IS_LITTLE_ENDIAN

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_FND_PRIMITIVE_TYPES_H_
