﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_FND_IFF_BINARY_H_
#define NW_SND_FND_IFF_BINARY_H_

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
//! @brief  チャンクヘッダ
//---------------------------------------------------------------------------
struct ChunkHeader
{
    ChunkHeader() :
        id(0),
        size(0)
    { }

    ChunkHeader(u32 id) :
        id(id),
        size(0)
    { }

    ChunkHeader(u32 id, u32 size) :
        id(id),
        size(size)
    { }

    u32      id;
    PcBinU32 size;
};

//---------------------------------------------------------------------------
//! @brief  チャンクヘッダ（ビッグエンディアン版）
//---------------------------------------------------------------------------
struct ChunkHeaderBE
{
    ChunkHeaderBE() :
        id(0),
        size(0)
    { }

    ChunkHeaderBE(u32 id) :
        id(id),
        size(0)
    { }

    ChunkHeaderBE(u32 id, u32 size) :
        id(id),
        size(size)
    { }

    u32        id;
    PcBeBinU32 size;
};

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_FND_IFF_BINARY_H_
