﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_EDIT_SYNC_REPLY_HANDLER_H_
#define NW_SND_EDIT_SYNC_REPLY_HANDLER_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/edit/hio/sndedit_HioProtocol.h>
#include <nw/snd/edit/hio/sndedit_HioMessageHandler.h>
#include <nw/snd/edit/protocol/sndedit_SyncPacket.h>

namespace nw {
namespace snd {
namespace edit {

class SoundEditSession;

namespace internal {

class HioPacketStream;

class SyncReplyHandler : public HioMessageHandlerImpl<HIO_MESSAGE_SYNC_REPLY, SyncReplyPacket>
{
public:
    SyncReplyHandler() { }
    virtual ~SyncReplyHandler() { }

public:
    void Initialize(SoundEditSession& session);
    void Finalize();

protected:
    //---------------------------------------------------------------------------
    //! @brief         読み込み済みの対象HIOメッセージを処理します。
    //!
    //! @param[in]     packet  HIO パケットを指定します。
    //! @param[in]     stream  返信用の出力ストリームを指定します。
    //!
    //! @return        HIOメッセージの処理結果を返します。
    //---------------------------------------------------------------------------
    virtual HioResult OnInvokeForReadTargetPacket(
        const SyncReplyPacket& packet,
        HioPacketStream& stream);

private:
    SoundEditSession* m_Session;
};

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_EDIT_SYNC_REPLY_HANDLER_H_
