﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * :include nw/snd/dw/snddw_VoicesWindow.h
 *
 * @file snddw_VoicesWindow.h
 */

#ifndef NW_SND_DW_VOICES_WINDOW_H_
#define NW_SND_DW_VOICES_WINDOW_H_

#include <nw/snd/dw/snddw_SoundWindow.h>
#include <nw/snd/dw/snddw_VoicesPanel.h>

namespace nw {
namespace snd {
namespace dw {

//---------------------------------------------------------------------------
//! @brief  Voice の状態を確認するためのデバッグウィンドウです。
//!
//!         このウィンドウには、特有の操作はありません。
//!
//! @see SoundWindowSystem クラス
//!
//! @date 2012/02/15 初版
//---------------------------------------------------------------------------
class VoicesWindow : public SoundWindow
{
    //! @name コンストラクタ/デストラクタ
    //@{
public:
    //---------------------------------------------------------------------------
    //! @brief    コンストラクタです。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    VoicesWindow();

    //---------------------------------------------------------------------------
    //! @brief    デストラクタです。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    ~VoicesWindow();
    //@}

    //! @name 取得/設定
    //@{
public:
    //---------------------------------------------------------------------------
    //! @brief    VoicesWindow を１つ作るために必要なメモリを取得します。
    //!
    //! @return 必要とするメモリです。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    virtual u32 GetRequiredSize() const;
    //@}

private:
    nw::snd::dw::VoicesPanel m_Panel;
};

} // namespace dw
} // namespace snd
} // namespace nw

#endif // NW_SDW_VOICES_WINDOW_H_
