﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_DW_PERFORMANCE_WINDOW_H_
#define NW_SND_DW_PERFORMANCE_WINDOW_H_

#include <nw/snd/dw/snddw_SoundWindow.h>
#include <nw/snd/dw/snddw_PerformancePanel.h>

namespace nw {
namespace snd {
namespace dw {

//---------------------------------------------------------------------------
//! @brief  パフォーマンスを確認するためのデバッグウィンドウです。
//!
//!         このウィンドウでは、以下の操作を行うことができます。
//!
//!         - プロファイルモードの切り替え  : (修飾キー) + ← or →
//!
//!         デフォルトの修飾キーは R です。
//!
//! @see SoundWindowSystem クラス
//! @see SoundWindowSystem::SetModifierKey
//! @see SoundWindowSystem::GetModifierKey
//!
//! @date 2012/03/09 キー操作に関する説明を修正
//! @date 2012/02/15 初版
//---------------------------------------------------------------------------
class PerformanceWindow : public SoundWindow
{
    //! @name コンストラクタ/デストラクタ
    //@{
public:
    //---------------------------------------------------------------------------
    //! @brief    コンストラクタです。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    PerformanceWindow();

    //---------------------------------------------------------------------------
    //! @brief    デストラクタです。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    ~PerformanceWindow();
    //@}

    //! @name 取得/設定
    //@{
public:
    //---------------------------------------------------------------------------
    //! @brief    PerformanceWindow を１つ作るために必要なメモリを取得します。
    //!
    //! @return 必要とするメモリです。
    //!
    //! @date 2012/02/15 初版
    //---------------------------------------------------------------------------
    virtual u32 GetRequiredSize() const;
    //@}

private:
    nw::snd::dw::PerformancePanel m_Panel;
};

} // namespace dw
} // namespace snd
} // namespace nw

#endif // NW_SND_DW_VOICES_WINDOW_H_
