﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_DW_MASTER_OUTPUT_PANEL_H_
#define NW_SND_DW_MASTER_OUTPUT_PANEL_H_

#include <nw/snd.h>
#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedLabel.h>
#include <nw/dw/control/dw_FixedStackPanel.h>
#include <nw/dw/control/dw_Canvas.h>
#include <nw/dw/control/dw_Separator.h>
#include <nw/snd/dw/control/snddw_WaveGraph.h>

namespace nw {
namespace snd {
namespace dw {

//---------------------------------------------------------------------------
//! @briefprivate
//---------------------------------------------------------------------------
class MasterOutputPanel : public nw::internal::dw::UIElement, snd::internal::ReadOnlyFinalMixCallback
{
private:
    static const u32 MAIN_CHANNEL_START     = 0;
    static const u32 DRC_CHANNEL_START      = 6;

    static const u32 MAIN_FL_INDEX          = 0;
    static const u32 MAIN_FR_INDEX          = 1;
    static const u32 MAIN_FC_INDEX          = 2;
    static const u32 MAIN_LFE_INDEX         = 3;
    static const u32 MAIN_RL_INDEX          = 4;
    static const u32 MAIN_RR_INDEX          = 5;
    static const u32 DRC_FL_INDEX           = 6;
    static const u32 DRC_FR_INDEX           = 7;
    static const u32 DRC_RL_INDEX           = 8;
    static const u32 DRC_RR_INDEX           = 9;

    static const u32 MAX_MAIN_CHANNEL_COUNT = 6;
    static const u32 MAX_DRC_CHANNEL_COUNT  = 4;
    static const u32 MAX_CHANNEL_COUNT      = MAX_MAIN_CHANNEL_COUNT + MAX_DRC_CHANNEL_COUNT;
    static const f32 MAX_SCALE_X;
    static const f32 MIN_SCALE_X;
    static const u32 SAMPLE_BUFFER_SIZE     = 192 * 1024;

    static const u32 SAMPLES_PER_AUDIOFRAME = 144;
    static const u32 RECORDING_BUFFER_SIZE  = SAMPLES_PER_AUDIOFRAME * MAX_MAIN_CHANNEL_COUNT * sizeof(s16);
    static const u32 GRAPH_CACHE_BUFFER_SIZE = 16 * 1024;

    static const u32 SAMPLES_PER_SEC = 48000;

public:
    MasterOutputPanel();
    virtual ~MasterOutputPanel();

public:
    void StartMonitoring();
    void StopMonitoring();

    void Initialize( void* memory, u32 memorySize );
    void Finalize();
    u32 GetRequiredSize() const;

    f32 GetScaleX() const;
    void SetScaleX(f32 value);

    void Pause();
    void Resume();
    bool IsPaused() const;

protected:
    /*override*/ bool OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);
    /*override*/ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);

private:
    /*override*/ void OnFinalMix(OutputDevice device, const FinalMixData* data);

    inline s16* GetSamples(u32 channel);
    inline s16* GetDrcSamples(u32 channel);

    void UpdateWaveGraph(const FinalMixData* data);
    void UpdateDrcWaveGraph(const FinalMixData* data);

    void ClearSamples();
    bool IsPressWindowControlKey(const nw::dev::Pad& pad) const;

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedStackPanel<MAX_CHANNEL_COUNT + MAX_CHANNEL_COUNT - 1> m_Container;

    internal::WaveGraph m_WaveGraphs[MAX_CHANNEL_COUNT];
    nw::internal::dw::Separator m_Separators[MAX_CHANNEL_COUNT-1];

    nw::internal::dw::UIElement m_Channels[MAX_CHANNEL_COUNT];
    nw::internal::dw::FixedUIElementList<2> m_ChannelContentsArray[MAX_CHANNEL_COUNT];
    nw::internal::dw::FixedLabel<12> m_ChannelLabels[MAX_CHANNEL_COUNT];

    nw::ut::MemoryAllocator m_DrawBufferAllocator;

    s16 m_Samples[MAX_CHANNEL_COUNT][SAMPLE_BUFFER_SIZE];
    u32 m_SampleCount;
    u32 m_CurrentSampleIndex;
    u32 m_DrcCurrentSampleIndex;

    s16 m_GraphCacheBuffers[MAX_CHANNEL_COUNT][GRAPH_CACHE_BUFFER_SIZE];

    nw::snd::OutputMode m_CurrentOutputMode;
    bool m_IsWaveGraphPaused;
    bool m_IsMonitoring;

    static MasterOutputPanel* s_pThis;

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
public:
    /*override*/ const char* ToString() const
    {
        return "MasterOutputPanel";
    }
#endif
};

} // dw
} // snd
} // nw

#endif // NW_SND_DW_MASTER_OUTPUT_PANEL_H_
