﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_DW_CONFIG_H_
#define NW_SND_DW_CONFIG_H_

#include <nw/types.h>

namespace nw {
namespace snd {
namespace dw {

class SoundWindowSystem;

//---------------------------------------------------------------------------
//! @briefprivate
//---------------------------------------------------------------------------
class Config
{
    friend class SoundWindowSystem;

public:
    static Config& GetInstance();

public:
    void SetWindowTitleLengthMax(u32 value);
    void SetWindowMax(u32 value);
    u32 GetWindowTitleLengthMax() const;
    u32 GetWindowMax() const;

private:
    Config();

private:
    void Seal();

private:
    u32 m_WindowTitleLengthMax;
    u32 m_WindowMax;
    bool m_IsSealed;
};

} // namespace dw
} // namespace snd
} // namespace nw

#endif // NW_SDW_CONFIG_H_
