﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/system/dw_Types.h>
#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedDockPanel.h>
#include <nw/dw/control/dw_FixedLabel.h>
#include <nw/snd/dw/control/snddw_PeakMeter.h>

namespace nw {
namespace snd {
namespace dw {
namespace internal {

//---------------------------------------------------------------------------
//! @briefprivate
//---------------------------------------------------------------------------
class FixedLabelVoiceCountPeakMeter : public nw::internal::dw::UIElement
{
private:
    typedef nw::internal::dw::UIElement Base;

    static const u32 LABEL_LENGTH = 32;
    static const char* VALUE_FORMAT;

public:
    FixedLabelVoiceCountPeakMeter();

public:
    nw::internal::dw::Orientation GetOrientation() const;
    void SetOrientation(nw::internal::dw::Orientation value);

    u32 GetValue() const;
    void SetValue(u32 value);

    u32 GetPeakValue() const;

    u32 GetMinimumValue() const;
    void SetMinimumValue(u32 value);

    u32 GetMaximumValue() const;
    void SetMaximumValue(u32 value);

    u32 GetPeakHoldChange() const;
    void SetPeakHoldChange(u32 value);

    u32 GetPeakHoldFrames() const;
    void SetPeakHoldFrames(u32 value);

    const nw::ut::Color4f GetBarColor() const;
    void SetBarColor(const nw::ut::Color4f& value);

protected:
    /*override*/ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedDockPanel<8> m_Container;
    nw::internal::dw::FixedLabel<LABEL_LENGTH> m_Label;
    nw::internal::dw::FixedLabel<LABEL_LENGTH> m_Label2;
    nw::internal::dw::FixedLabel<LABEL_LENGTH> m_ValueLabel;
    nw::internal::dw::FixedLabel<LABEL_LENGTH> m_Label3;
    nw::internal::dw::FixedLabel<LABEL_LENGTH> m_PeakValueLabel;
    nw::internal::dw::FixedLabel<LABEL_LENGTH> m_Label4;
    nw::internal::dw::FixedLabel<LABEL_LENGTH> m_MaximumValueLabel;
    PeakMeter m_PeakMeter;

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
public:
    /*override*/ const char* ToString() const
    {
        return "FixedLabelVoiceCountPeakMeter";
    }
#endif
};

} // internal
} // dw
} // snd
} // nw
