﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_CTRL_SOUND_CONTROLLER_IMPL_H_
#define NW_SND_CTRL_SOUND_CONTROLLER_IMPL_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/config.h>
#include <nw/snd/snd_SoundArchive.h>
#include <nw/snd/fnd/os/sndfnd_CriticalSection.h>
#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <nw/snd/edit/sndedit_Result.h>
#include <nw/snd/ctrl/sndctrl_Config.h>
#include <nw/snd/ctrl/sndctrl_SoundController.h>
#include <nw/snd/ctrl/sndctrl_SoundParameters.h>


#if defined(NW_PLATFORM_CTR)
#if NN_CURRENT_VERSION_NUMBER >= NN_VERSION_NUMBER(4,0,0,0)
#pragma diag_suppress 1301 // padding inserted in struct.
#pragma diag_suppress 2530 // padding added to end of struct.
#endif
#endif

namespace nw {
namespace snd {

class SoundHandle;
class SequenceSoundHandle;
class SoundArchivePlayer;

namespace ctrl {
namespace internal {

//! @brief  サウンドを制御するクラスです。
class SoundControllerImpl : public ctrl::SoundController
{
public: // 型の定義
    // 再生前のアクション
    typedef void (*PreplayAction)(SoundController& target, SoundArchive::ItemId soundID, void* userParam);

private:
    // シーケンス変数操作用関数
    typedef bool (*ReadVariableFunc)(
        SequenceSoundHandle* handle,
        snd::internal::fnd::BinS32 trackNo,
        snd::internal::fnd::BinS32 varNo,
        snd::internal::fnd::BinS32* var
    );
    typedef bool (*WriteVariableFunc)(
        SequenceSoundHandle* handle,
        snd::internal::fnd::BinS32 trackNo,
        snd::internal::fnd::BinS32 varNo,
        snd::internal::fnd::BinS32 var
    );

public: // コンストラクタ
    SoundControllerImpl();
    virtual ~SoundControllerImpl() { }

public: // メソッド
    edit::Result Initialize(SoundHandle* soundHandle, SoundArchivePlayer* soundArchivePlayer);
    void Finalize();

    virtual bool IsInitialized() const { return m_SoundHandle != NULL; }

    virtual const SoundHandle* GetSoundHandle() const { return m_SoundHandle; }
    virtual SoundHandle* GetSoundHandle() { return m_SoundHandle; }

    virtual SoundArchive::ItemId GetSoundID() const { return m_SoundID; }
    edit::Result SetSoundID(SoundArchive::ItemId soundID);

    virtual const char* GetLabel() const;
    edit::Result SetLabel(const char* label);

    u32 GetSoundIndex() const;
    edit::Result SetSoundIndex(u32 index);

    virtual State GetState() const { return m_State; }

    virtual edit::Result Play(const SoundStartable::StartInfo * pStartInfo = NULL);
    virtual edit::Result Stop();
    virtual edit::Result Pause();

    void Update();

    virtual const SoundParameters& GetParameters() const { return m_Parameters; }
    virtual SoundParameters& GetParameters() { return m_Parameters; }

    virtual void SetParameterDirty(bool isDirty);

    void SetPreplayAction(PreplayAction action, void* userParam)
    {
        m_PreplayAction = action;
        m_UserParam = userParam;
    }

    // シーケンス変数の操作
    bool GetVariables(ToolSoundSequenceVariableContainer* pVariables);
    bool SetVariables(const ToolSoundSequenceVariableContainer* pVariables);
    void InvalidateAllVariables();

private:
    void ApplySequenceVariables();

    // シーケンス変数の制御
    bool GetVariables(ToolSoundSequenceVariableContainer* pVariables, ReadVariableFunc pFunc);
    bool SetVariables(SequenceVariableContainer& Variables, WriteVariableFunc pFunc);
    void InvalidateVariables(ToolSoundSequenceVariableContainer* pVariables);

private:
    void UpdateState();
    void UpdateParameters();


private: // メンバ変数
    SoundHandle*         m_SoundHandle;
    SoundArchivePlayer*  m_SoundArchivePlayer;
    SoundArchive::ItemId m_SoundID;
    State                m_State;
    bool                 m_IsParameterDirty;
    SoundParameters      m_Parameters;
    snd::internal::fnd::FndCriticalSection   m_Lock;

    PreplayAction m_PreplayAction;
    void*         m_UserParam;
};

} // namespace nw::snd::ctrl::internal
} // namespace nw::snd::ctrl
} // namespace nw::snd
} // namespace nw

#if defined(NW_PLATFORM_CTR)
#if NN_CURRENT_VERSION_NUMBER >= NN_VERSION_NUMBER(4,0,0,0)
#pragma diag_default 1301 // padding inserted in struct.
#pragma diag_default 2530 // padding added to end of struct.
#endif
#endif

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_CTRL_SOUND_CONTROLLER_IMPL_H_
