﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_CTRL_CONFIG_H_
#define NW_SND_CTRL_CONFIG_H_

namespace nw {
namespace snd {
namespace ctrl {

//---------------------------------------------------------------------------
//! @brief  【β版】sndctrl の制限値をまとめるクラスです。
//---------------------------------------------------------------------------
class Limits
{
public:
    //---------------------------------------------------------------------------
    // エフェクトバス数
    //---------------------------------------------------------------------------
#if defined(NW_PLATFORM_WIN32)
    static const u32 MAX_EFFECT_BUS_COUNT = 3;  //!< エフェクトバスの最大数です。
#elif defined(NW_USE_NINTENDO_SDK)
    // TODO: independent
    static const u32 MAX_EFFECT_BUS_COUNT = 3;  //!< エフェクトバスの最大数です。
#elif defined(NW_PLATFORM_CAFE)
    static const u32 MAX_EFFECT_BUS_COUNT = 3;  //!< エフェクトバスの最大数です。
#elif defined(NW_PLATFORM_CTR)
    static const u32 MAX_EFFECT_BUS_COUNT = 2;  //!< エフェクトバスの最大数です。
#endif

    //---------------------------------------------------------------------------
    // トラック数
    //---------------------------------------------------------------------------
#if defined(NW_PLATFORM_WIN32)
    static const u32 MAX_STREAM_TRACK_COUNT = 4;    //!< ストリームトラックの最大数です。
    static const u32 MAX_SEQUENCE_TRACK_COUNT = 16; //!< シーケンストラックの最大数です。
#elif defined(NW_USE_NINTENDO_SDK)
    // TODO: independent
    static const u32 MAX_STREAM_TRACK_COUNT = 4;    //!< ストリームトラックの最大数です。
    static const u32 MAX_SEQUENCE_TRACK_COUNT = 16; //!< シーケンストラックの最大数です。
#elif defined(NW_PLATFORM_CAFE)
    static const u32 MAX_STREAM_TRACK_COUNT = 4;    //!< ストリームトラックの最大数です。
    static const u32 MAX_SEQUENCE_TRACK_COUNT = 16; //!< シーケンストラックの最大数です。
#elif defined(NW_PLATFORM_CTR)
    static const u32 MAX_STREAM_TRACK_COUNT = 8;    //!< ストリームトラックの最大数です。
    static const u32 MAX_SEQUENCE_TRACK_COUNT = 16; //!< シーケンストラックの最大数です。
#endif

    //---------------------------------------------------------------------------
    // プラットフォーム特有の定義
    //---------------------------------------------------------------------------
#if defined(NW_PLATFORM_CAFE)
    static const u32 MAX_REMOTE_COUNT = 4;      //!< リモコンの最大数です。
    static const u32 MAX_DRC_COUNT = 2;         //!< DRC の最大数です。
#endif

};

} // namespace nw::snd::ctrl
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CTRL_CONFIG_H_
