﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_CTRL_UPDATE_SOUND_INFO_PACKET_H_
#define NW_SND_CTRL_UPDATE_SOUND_INFO_PACKET_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/ut/ut_Inlines.h>
#include <nw/snd/edit/hio/sndedit_HioProtocol.h>
#include <nw/snd/edit/res/sndedit_ResTypes.h>

namespace nw {
namespace snd {
namespace ctrl {
namespace internal {

//---------------------------------------------------------------------------
//! @brief  サウンド情報の更新を通知するパケットです。
//---------------------------------------------------------------------------
class UpdateSoundInfoPacket : public edit::internal::HioPacket
{
public:
    static const u32 SOUND_COUNT = 4;    //!< サウンド数です。（暫定なので 4 固定）

    enum SoundState
    {
        SOUND_DISABLED = 0,
        SOUND_STOPPED = 1,
        SOUND_PLAYING = 2,
        SOUND_PAUSED = 3
    };

public:
    class Body : public edit::internal::HioPacketBody
    {
    public:
        Body() : m_Count(SOUND_COUNT)
        {
            for(u32 i = 0; i < SOUND_COUNT; ++i)
            {
                m_States[i] = 0;
            }
        }

    public:
        void SetSoundState(u32 index, SoundState value)
        {
            NW_ASSERT(index < SOUND_COUNT);
            m_States[index] = static_cast<u32>(value);
        }

    private:
        snd::internal::fnd::BinU32 m_Count; //!< 対象サウンドハンドル数です。
        snd::internal::fnd::BinU32 m_States[SOUND_COUNT];
    };

public:
    UpdateSoundInfoPacket() :
      HioPacket(edit::internal::HIO_MESSAGE_UPDATE_SOUND_INFO, sizeof(Body))
    {
    }

public:
    static u32 GetRequiredSize()
    {
        // 固定パケットサイズ
        return sizeof(UpdateSoundInfoPacket);
    }

    Body&       GetBody() { return m_Body; }
    const Body& GetBody() const { return m_Body; }

private:
    Body m_Body;
};

} // namespace nw::snd::ctrl::internal
} // namespace nw::snd::ctrl
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_CTRL_UPDATE_SOUND_INFO_PACKET_H_
