﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_CTRL_STOP_SOUND_PACKET_H_
#define NW_SND_CTRL_STOP_SOUND_PACKET_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/edit/hio/sndedit_HioProtocol.h>
#include <nw/snd/edit/res/sndedit_ResTypes.h>

namespace nw {
namespace snd {
namespace ctrl {
namespace internal {

//---------------------------------------------------------------------------
//! @brief  サウンドの停止を要求するパケットです。
//---------------------------------------------------------------------------
class StopSoundPacket : public edit::internal::HioPacket
{
public:
    class Body : public edit::internal::HioPacketBody
    {
    public:
        u32 GetSoundHandleIndex() const { return m_SoundHandleIndex; }

    private:
        snd::internal::fnd::BinU32 m_SoundHandleIndex; //!< 対象サウンドハンドルのインデックスです。
    };

public:
    StopSoundPacket() :
      edit::internal::HioPacket(edit::internal::HIO_MESSAGE_STOP_SOUND, 0)
    {
    }

public:
    static u32 GetRequiredSize()
    {
        // 固定パケットサイズ
        return sizeof(StopSoundPacket);
    }

    Body&       GetBody() { return m_Body; }
    const Body& GetBody() const { return m_Body; }

private:
    Body m_Body;
};

} // namespace nw::snd::ctrl::internal
} // namespace nw::snd::ctrl
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_CTRL_STOP_SOUND_PACKET_H_
