﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_CTRL_PLAY_SOUND_PACKET_H_
#define NW_SND_CTRL_PLAY_SOUND_PACKET_H_

#include <nw/snd/edit/hio/sndedit_HioProtocol.h>
#include <nw/snd/edit/res/sndedit_ResTypes.h>

namespace nw {
namespace snd {
namespace ctrl {
namespace internal {

//---------------------------------------------------------------------------
//! @brief  サウンドの再生を要求するパケットです。
//---------------------------------------------------------------------------
class PlaySoundPacket : public edit::internal::HioPacket
{
public:
    class Body : public edit::internal::HioPacketBody
    {
    public:
        static u32 GetRequiredSize(u32 maxItemName)
        {
            return edit::internal::ResName::GetRequiredSize(maxItemName);
        }

        u32 GetSoundHandleIndex() const { return m_SoundHandleIndex; }

        const char* GetItemName() const { return m_ItemName.str; }

        u32 GetItemNameLength() const { return m_ItemName.len; }

    private:
        snd::internal::fnd::BinU32  m_SoundHandleIndex; //!< 対象サウンドハンドルのインデックスです。
        edit::internal::ResNameData m_ItemName;         //!< 対象アイテム名です。
    };

public:
    PlaySoundPacket() :
      edit::internal::HioPacket(edit::internal::HIO_MESSAGE_PLAY_SOUND, 0)
    {
    }

public:
    static u32 GetRequiredSize(u32 maxItemName)
    {
        // 固定パケットサイズ + 名前の長さ
        return sizeof(HioPacket) + Body::GetRequiredSize(maxItemName);
    }

    Body&       GetBody() { return m_Body; }
    const Body& GetBody() const { return m_Body; }

private:
    Body m_Body;
};

} // namespace nw::snd::ctrl::internal
} // namespace nw::snd::ctrl
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CTRL_PLAY_SOUND_PACKET_H_
