﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * :include nw/snd.h
 *
 * @file snd.h
 */


#ifndef NW_SND_H_
#define NW_SND_H_


//---------------------------------------------------------------------------
//! @namespace nw::snd
//!
//! @brief    サウンドライブラリの名前空間です。
//!           サウンドプログラマーズガイドなどもあわせてご参照ください。
//!
//! @date 2011/07/05 NW4F 1.0.0-PR 公開に向けた調整
//---------------------------------------------------------------------------


#include <nw/snd/snd_Config.h>

#include <nw/snd/snd_AnimEventPlayer.h>
#include <nw/snd/snd_AnimSound.h>
#include <nw/snd/snd_AnimSoundFile.h>
#include <nw/snd/snd_AnimSoundFileReader.h>
#include <nw/snd/snd_AnimSoundImpl.h>
#include <nw/snd/snd_BankFile.h>
#include <nw/snd/snd_BankFileReader.h>
#include <nw/snd/snd_BasicSound.h>
#include <nw/snd/snd_BiquadFilterCallback.h>
#include <nw/snd/snd_BiquadFilterPresets.h>
#include <nw/snd/snd_CurveAdshr.h>
#include <nw/snd/snd_CurveLfo.h>
#include <nw/snd/snd_Debug.h>
#include <nw/snd/snd_DriverCommand.h>
#include <nw/snd/snd_DspadpcmReader.h>
#include <nw/snd/snd_Command.h>
#include <nw/snd/snd_CommandManager.h>
#include <nw/snd/snd_Voice.h>
#include <nw/snd/snd_VoiceCommand.h>
#include <nw/snd/snd_AxVoice.h>
#include <nw/snd/snd_NwVoice.h>
#include <nw/snd/snd_ElementType.h>
#include <nw/snd/snd_ExternalSoundPlayer.h>
#include <nw/snd/snd_FinalMixCallback.h>
#include <nw/snd/snd_FrameHeap.h>
#include <nw/snd/snd_FsSoundArchive.h>
#include <nw/snd/snd_Global.h>
#include <nw/snd/snd_GroupFile.h>
#include <nw/snd/snd_GroupFileReader.h>
#include <nw/snd/snd_InstancePool.h>
#include <nw/snd/snd_ItemType.h>
#include <nw/snd/snd_MemorySoundArchive.h>
#include <nw/snd/snd_MidiStreamParser.h>
#include <nw/snd/snd_MoveValue.h>
#include <nw/snd/snd_PlayerHeap.h>
#include <nw/snd/snd_PlayerHeapDataManager.h>
#include <nw/snd/snd_ProfileReader.h>
#include <nw/snd/snd_SequenceSound.h>
#include <nw/snd/snd_SequenceSoundFile.h>
#include <nw/snd/snd_SequenceSoundFileReader.h>
#include <nw/snd/snd_SequenceSoundHandle.h>
#include <nw/snd/snd_Sound3DActor.h>
#include <nw/snd/snd_Sound3DCalculator.h>
#include <nw/snd/snd_Sound3DEngine.h>
#include <nw/snd/snd_Sound3DListener.h>
#include <nw/snd/snd_Sound3DManager.h>
#include <nw/snd/snd_SoundActor.h>
#include <nw/snd/snd_SoundArchive.h>
#include <nw/snd/snd_SoundArchiveFile.h>
#include <nw/snd/snd_SoundArchiveFileReader.h>
#include <nw/snd/snd_SoundArchiveLoader.h>
#include <nw/snd/snd_SoundArchivePlayer.h>
#include <nw/snd/snd_SoundDataManager.h>
#include <nw/snd/snd_SoundHandle.h>
#include <nw/snd/snd_SoundHeap.h>
#include <nw/snd/snd_SoundInstanceManager.h>
#include <nw/snd/snd_SoundMemoryAllocatable.h>
#include <nw/snd/snd_SoundPlayer.h>
#include <nw/snd/snd_SoundStartable.h>
#include <nw/snd/snd_SoundSystem.h>
#include <nw/snd/snd_StreamSound.h>
#include <nw/snd/snd_StreamSoundFile.h>
#include <nw/snd/snd_StreamSoundFileLoader.h>
#include <nw/snd/snd_StreamSoundFileReader.h>
#include <nw/snd/snd_StreamSoundPrefetchFile.h>
#include <nw/snd/snd_StreamSoundPrefetchFileReader.h>
#include <nw/snd/snd_StreamSoundHandle.h>
#include <nw/snd/snd_Task.h>
#include <nw/snd/snd_TaskManager.h>
#include <nw/snd/snd_TaskThread.h>
#include <nw/snd/snd_ThreadStack.h>
#include <nw/snd/snd_Util.h>
#include <nw/snd/snd_Util.h>
#include <nw/snd/snd_WaveArchiveFile.h>
#include <nw/snd/snd_WaveArchiveFileReader.h>
#include <nw/snd/snd_WaveFile.h>
#include <nw/snd/snd_WaveFileReader.h>
#include <nw/snd/snd_WaveSound.h>
#include <nw/snd/snd_WaveSoundFile.h>
#include <nw/snd/snd_WaveSoundFileReader.h>
#include <nw/snd/snd_WaveSoundHandle.h>


// nw::snd::internal::driver

#include <nw/snd/snd_Bank.h>
#include <nw/snd/snd_BasicSoundPlayer.h>
#include <nw/snd/snd_Channel.h>
#include <nw/snd/snd_ChannelManager.h>
#include <nw/snd/snd_DisposeCallback.h>
#include <nw/snd/snd_DisposeCallbackManager.h>
#include <nw/snd/snd_MidiSequencePlayer.h>
#include <nw/snd/snd_MidiSequenceTrack.h>
#include <nw/snd/snd_MidiSequenceTrackAllocator.h>
#include <nw/snd/snd_MmlCommand.h>
#include <nw/snd/snd_MmlParser.h>
#include <nw/snd/snd_MmlSequenceTrack.h>
#include <nw/snd/snd_MmlSequenceTrackAllocator.h>
#include <nw/snd/snd_NoteOnCallback.h>
#include <nw/snd/snd_SequenceSoundPlayer.h>
#include <nw/snd/snd_SequenceTrack.h>
#include <nw/snd/snd_SequenceTrackAllocator.h>
#include <nw/snd/snd_SoundThread.h>
#include <nw/snd/snd_StreamBufferPool.h>
#include <nw/snd/snd_StreamSoundPlayer.h>
#include <nw/snd/snd_StreamTrack.h>
#include <nw/snd/snd_MultiVoice.h>
#include <nw/snd/snd_MultiVoiceManager.h>
#include <nw/snd/snd_WavePlayer.h>
#include <nw/snd/snd_WaveSoundPlayer.h>
#include <nw/snd/snd_HardwareManager.h>


// エフェクト関連
#include <nw/snd/snd_FxBase.h>
#include <nw/snd/snd_FxDelay.h>
#include <nw/snd/snd_FxChorus.h>
#include <nw/snd/snd_FxReverbStd.h>
#include <nw/snd/snd_FxReverbHi.h>
#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)
#include <nw/snd/snd_FxMultiChReverb.h>
#include <nw/snd/snd_FxMultiChDelay.h>
#include <nw/snd/snd_FxMultiChChorus.h>
#endif
#if defined(NW_SND_CONFIG_ENABLE_SOUND2)
#include <nw/snd/snd_Fx2Reverb.h>
#include <nw/snd/snd_Fx2Delay.h>
#include <nw/snd/snd_Fx2Chorus.h>
#include <nw/snd/snd_Fx2Flanger.h>
#include <nw/snd/snd_Fx2Overdrive.h>
#include <nw/snd/snd_Fx2Compressor.h>
#include <nw/snd/snd_Fx2Pitchshift.h>
#include <nw/snd/snd_Fx2ReverbI3dl2.h>
#endif
#include <nw/snd/snd_AxfxImpl.h>

#ifdef NW_PLATFORM_CAFE
// リモコン関連
#include <nw/snd/snd_RemoteSpeaker.h>
#include <nw/snd/snd_RemoteSpeakerManager.h>
#endif

#endif /* NW_SND_H_ */

