﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SCFONT_UTIL_H_
#define NW_SCFONT_UTIL_H_

#include <nw/types.h>

namespace nw
{

namespace lyt
{

class Pane;

} // namespace nw::lyt

namespace scfont
{

//---------------------------------------------------------------------------
//! @brief 指定されたペイン以下を再帰的に検索し、スケーラブルフォントが設定されているテキストボックスの文字を登録します。
//!
//! @details
//! スケーラブルフォントでないフォント(例えばResFont)が登録されているペインの文字は登録しませんので、ご注意ください。
//!
//! @param[in] pane         再帰的に検索するルートのペインです。
//! @param[in] lockGroup    文字をロックする際のグループ。0から31までの数値で指定してください。-1を指定した場合はロックしません。
//!
//! @return プロットが必要な文字が何文字あったかを返します。
//!
//---------------------------------------------------------------------------
u32 RegisterGlyphFromTextBoxRecursive(const lyt::Pane* pane, s32 lockGroup = -1);

} // namespace nw::scfont
} // namespace nw

#endif // NW_SCFONT_UTIL_H_
