﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_MATH_EQUATION_H_
#define NW_MATH_EQUATION_H_

#include <nw/math/math_Config.h>


namespace nw { namespace math {

//---------------------------------------------------------------------------
//! @brief       二次方程式 ax^2 + bx + c = 0 の実数解を求めます。
//!
//! @param[out]  root    実数解を格納する配列へのポインタ。
//!                      二次方程式には最大で2つの実数解が存在しますので、
//!                      配列の大きさは2以上でなければなりません。
//! @param[in]   a       対象の二次方程式の係数。0 であってはいけません。
//! @param[in]   b       対象の二次方程式の係数。
//! @param[in]   c       対象の二次方程式の係数。
//!
//! @return      実数解の個数。
//!              root が指す配列の先頭から順に個数分の解が格納されます。
//---------------------------------------------------------------------------
int SolveEquation2(f32* root, f32 a, f32 b, f32 c);

//---------------------------------------------------------------------------
//! @brief       三次方程式 ax^3 + bx^2 + cx + d = 0 の実数解を求めます。
//!
//! @param[out]  root    実数解を格納する配列へのポインタ。
//!                      三次方程式には最大で3つの実数解が存在しますので、
//!                      配列の大きさは3以上でなければなりません。
//! @param[in]   a       対象の三次方程式の係数。0 であってはいけません。
//! @param[in]   b       対象の三次方程式の係数。
//! @param[in]   c       対象の三次方程式の係数。
//! @param[in]   d       対象の三次方程式の係数。
//!
//! @return      実数解の個数。
//!              root が指す配列の先頭から順に個数分の解が格納されます。
//---------------------------------------------------------------------------
int SolveEquation3(f32* root, f32 a, f32 b, f32 c, f32 d);

//---------------------------------------------------------------------------
//! @brief       四次方程式 ax^4 + bx^3 + cx^2 + dx + e = 0 の実数解を求めます。
//!
//! @param[out]  root    実数解を格納する配列へのポインタ。
//!                      四次方程式には最大で4つの実数解が存在しますので、
//!                      配列の大きさは4以上でなければなりません。
//! @param[in]   a       対象の四次方程式の係数。0 であってはいけません。
//! @param[in]   b       対象の四次方程式の係数。
//! @param[in]   c       対象の四次方程式の係数。
//! @param[in]   d       対象の四次方程式の係数。
//! @param[in]   e       対象の四次方程式の係数。
//!
//! @return      実数解の個数。
//!              root が指す配列の先頭から順に個数分の解が格納されます。
//---------------------------------------------------------------------------
int SolveEquation4(f32* root, f32 a, f32 b, f32 c, f32 d, f32 e);


}}  // nw::math

/* NW_MATH_EQUATION_H_ */
#endif
