﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_MATH_CONSTANT_H_
#define NW_MATH_CONSTANT_H_

#include <cfloat>
#include <nw/math/math_Config.h>
#include <limits>

namespace nw { namespace math {


extern const f32 F_E;                 //!< ネピア数 (自然対数の底) e
extern const f32 F_LOG2E;             //!< log2(e)
extern const f32 F_LOG10E;            //!< log10(e)
extern const f32 F_LN2;               //!< ln(2)
extern const f32 F_LN10;              //!< ln(10)
extern const f32 F_PI;                //!< π
extern const f32 F_SQRTPI;            //!< sqrt(π)
extern const f32 F_SQRT2;             //!< sqrt(2)
extern const f32 F_SQRT3;             //!< sqrt(3)

extern const f32 F_INVLN2;            //!< 1/ln2


extern const f32 F_MAX;               //!< 最大の正の数 = 3.40282346638529 * 10^38
extern const f32 F_MIN;               //!< 最小の正の数 = 1.17549435082229 * 10^-38

extern const u32 I_QUARTER_ROUND_IDX; //!< インデックス角度での1/4周
extern const u32 I_HALF_ROUND_IDX;    //!< インデックス角度での半周

namespace internal
{
    extern const u32 I_NAN;   // sign=+ exp=max frac=max
    extern const u32 I_INF;   // sign=+ exp=max frac=0
    extern const u32 I_NINF;  // sign=- exp=max frac=0
    extern const u32 I_ULP;   // sign=+ exp=-23 frac=0
} /* namespace internal */

extern const f32 F_NAN;  //!< 非数
extern const f32 F_INF;  //!< ∞
extern const f32 F_NINF; //!< -∞
extern const f32 F_ULP;  //!< 1.0f + x != 1.0f を満たす最小の正の値

}}  // nw::math

/* NW_MATH_CONSTANT_H_ */
#endif
