﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_LYT_SHADERCONNECTION_H_
#define NW_LYT_SHADERCONNECTION_H_

#include <cafe/gfd.h>
#include <cafe/os.h>

namespace nw
{
namespace lyt
{

struct ShaderConnection
{
    GX2VertexShader* m_VertexShader;
    GX2PixelShader* m_PixelShader;
    GX2FetchShader m_FetchShader;
    void* m_FetchShaderBuffer;
    GX2AttribStream* m_Attributes;
    gfnd::ShaderUniformId* m_UniformIds;
    gfnd::DisplayList m_ShaderDisplayList;
    bool m_IsMultiTextureEnabled;
};

} // namespace nw::lyt
} // namespace nw

#endif // NW_LYT_SHADERCONNECTION_H_
