﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_LYT_PROFILEHELPER_H_
#define NW_LYT_PROFILEHELPER_H_

#include <nw/lyt/lyt_Types.h>

namespace nw
{
namespace lyt
{

class Layout;
class Pane;

//---------------------------------------------------------------------------
//! @brief レイアウト用のプロファイル支援クラスです。
//---------------------------------------------------------------------------
class ProfileHelper
{
    NW_DISALLOW_COPY_AND_ASSIGN(ProfileHelper);

public:
    //----------------------------------------
    //! @name ユーティリティ
    //@{

    //! @brief        レイアウト内のグループの数を取得します。
    //!
    //! @param[in] layout   情報を取得するレイアウトです。
    //!
    //! @return グループ数です。
    //!
    static int GetQuantityOfGroup(const Layout& layout);

    //! @brief        レイアウト内のペインの数を取得します。
    //!
    //! @param[in] pane 情報を取得するペインです。
    //!
    //! @return ペイン数です。
    //!
    static int GetQuantityOfAllPane(const Pane* pane);

    //! @brief        レイアウト内の任意のペインの数を取得します。
    //!
    //! @param[in] paneType ペインの種類です。
    //! @param[in] pane     情報を取得するペインです。
    //!
    //! @return ペイン数です。
    //!
    static int GetQuantityOf(PaneType paneType, const Pane* pane);

    //@}

private:
    ProfileHelper() {}
    ~ProfileHelper() {}
};

} // namespace lyt
} // namespace nw

#endif // NW_LYT_PROFILEHELPER_H_

