﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_LYT_INIT_H_
#define NW_LYT_INIT_H_

#include <nw/types.h>

namespace nw
{
namespace ut
{

class IAllocator;

}

namespace lyt
{

//---------------------------------------------------------------------------
//! @brief レイアウトライブラリの初期化を行います。
//!
//! @details
//! レイアウトライブラリを使用する前に必ず呼び出してください。
//!
//! @param[in] pAllocator   メモリアロケータです。
//!
//! @sa Layout::SetAllocator
//!
//---------------------------------------------------------------------------
void Initialize(nw::ut::IAllocator* pAllocator);

} // namespace nw::lyt
} // namespace nw

#endif // NW_LYT_INIT_H_
