﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_LYT_BOUNDING_H_
#define NW_LYT_BOUNDING_H_

#include <nw/ut/ut_RuntimeTypeInfo.h>

#include <nw/lyt/lyt_Pane.h>

namespace nw
{
namespace lyt
{

namespace res
{

struct Bounding;

}   // namespace res

struct BuildResSet;
class DrawInfo;

//---------------------------------------------------------------------------
//! @brief 境界を表すペインです。
//!
//---------------------------------------------------------------------------
class Bounding : public Pane
{
    typedef Pane Base;

public:
    //! 実行時型情報です。
    NW_UT_RUNTIME_TYPEINFO(Bounding::Base);

    //----------------------------------------
    //! @name コンストラクタ／デストラクタ
    //@{

    //! @brief コンストラクタです。
    //!
    Bounding()
    {}

    //! @brief コンストラクタです。
    //!
    //! @details
    //! size で指定したサイズのペインを生成します。
    //!
    //! @param[in] size ペインのサイズです。
    //!
    explicit Bounding(const Size& size)
    {
        SetSize(size);
    }

    //! @brief コンストラクタです。
    //!
    //! @details
    //! pBlock で指定したリソースからペインを生成します。
    //!
    //! @param[in] pBaseBlock       このペインが所属するレイアウトが保持しているリソースへのポインタです。
    //! @param[in] pOverrideBlock   上書きを行ったリソースへのポインタです。上書きが行われていないときはNULLになります。
    //! @param[in] buildArgSet      構築時の引数への参照です。
    //!
    Bounding(
        const res::Bounding* pBaseBlock,
        const res::Bounding* pOverrideBlock,
        const BuildArgSet& buildArgSet);

    //! @brief コピーコンストラクタです。
    //!
    //! @details
    //! 引数で指定したペインをコピーしたペインを作成します。
    //!
    //! ペインの元々のレイアウトデータの状態ではなく、そのときの状態でコピーします
    //! のでご注意ください。つまり、アニメーションを再生した後はそのままの状態で
    //! コピーします。
    //!
    //! ただし、このメソッドではペインの親子関係はコピーしませんので、ご注意ください。
    //! つまり、ペインは親を持たず、子のリストが空の状態で作られます。
    //! ペインツリーに登録するためには、明示的にペインにAppendChildしてください。
    //!
    //! また、アニメーションについても、何もバインドされていない状態になります。
    //!
    //! @param[in] bounding コピー元のペインです。
    //!
    explicit Bounding(const Bounding& bounding);

    //! @brief デストラクタです。
    //!
    virtual ~Bounding();

    //@}

protected:

    //! @brief 自身の描画処理を行います。
    //!
    //! @param[in] drawInfo 描画情報です。
    //!
    virtual void DrawSelf(DrawInfo& drawInfo);

private:
    // コピー演算子を禁止します。
    const Bounding& operator=( const Bounding& );
};

} // namespace nw::lyt
} // namespace nw

#endif // NW_LYT_BOUNDING_H_

