﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_GFND_TEXTRUE_CAFE_GX2_H_
#define NW_GFND_TEXTRUE_CAFE_GX2_H_

#include <nw/gfnd/gfnd_Texture.h>
#include <cafe/gx2.h>

namespace nw
{
namespace gfnd
{

//---------------------------------------------------------------------------
//! @brief   Cafe GX2 用テクスチャを表すクラスです。
//---------------------------------------------------------------------------
class TextureCafeGX2 : public Texture
{
public:
    NW_UT_RUNTIME_TYPEINFO(Texture)

    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    TextureCafeGX2()
        : Texture(),
        m_GX2Texture( NULL ) {}

    //---------------------------------------------------------------------------
    //! @brief        デストラクタです。
    //---------------------------------------------------------------------------
    virtual ~TextureCafeGX2() {}


    //---------------------------------------------------------------------------
    //! @brief 幅を取得します。
    //!
    //! @return 幅の値を返します。
    //---------------------------------------------------------------------------
    virtual u32 GetWidth() const
    {
        NW_ASSERT_NOT_NULL( m_GX2Texture );
        return m_GX2Texture->surface.width;
    }

    //---------------------------------------------------------------------------
    //! @brief 高さを取得します。
    //!
    //! @return 高さの値を返します。
    //---------------------------------------------------------------------------
    virtual u32 GetHeight() const
    {
        NW_ASSERT_NOT_NULL( m_GX2Texture );
        return m_GX2Texture->surface.height;
    }

    //---------------------------------------------------------------------------
    //! @brief GX2Texture へのポインタを取得します。
    //!
    //! @return GX2Texture へのポインタを返します。
    //---------------------------------------------------------------------------
    const GX2Texture* GetGX2Texture() const
    {
        return m_GX2Texture;
    }

    //---------------------------------------------------------------------------
    //! @brief GX2Texture へのポインタを取得します。
    //!
    //! @return GX2Texture へのポインタを返します。
    //---------------------------------------------------------------------------
    GX2Texture* GetGX2Texture()
    {
        return m_GX2Texture;
    }

    //---------------------------------------------------------------------------
    //! @brief GX2Texture をセットします。
    //!
    //! @param[in]    texture          GX2Texture へのポインタです。
    //---------------------------------------------------------------------------
    void SetGX2Texture(GX2Texture* texture)
    {
        m_GX2Texture = texture;
    }

private:
    GX2Texture* m_GX2Texture;
};

} // namespace nw::gfnd
} // namespace nw

#endif // NW_GFND_TEXTRUE_CAFE_GX2_H_
