﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_G3D_MATH_VECTOR3_H_
#define NW_G3D_MATH_VECTOR3_H_

#include <nw/g3d/g3d_config.h>

namespace nw { namespace g3d { namespace math {

class Mtx34;
class Mtx44;
class Quat;

#if defined( _MSC_VER )
#pragma warning(push)
#pragma warning(disable:4201)
#endif
struct Vec3_t
{
    enum { DIM = 3, DIM_PS = DIM / 2 };

    union
    {
        struct
        {
            float x, y, z;
        };
        float a[DIM];
#if NW_G3D_IS_HOST_CAFE
        f32x2 ps[DIM_PS];
#endif
    };
};
#if defined( _MSC_VER )
#pragma warning(pop)
#endif

class Vec3 : public Vec3_t
{
public:
    static Vec3 Make(float x, float y, float z);
    static Vec3* Cast(float* a);
    static const Vec3* Cast(const float* a);

    // セット
    Vec3& Set(float x, float y, float z);
    Vec3& Set(const float* a);
    Vec3& Set(const Vec3& v);
    Vec3& Zero();
    Vec3& Neg(const Vec3& v);
    Vec3& Rcp(const Vec3& v);

    // 加減乗除
    Vec3& Add(const Vec3& lhs, const Vec3& rhs);
    Vec3& Sub(const Vec3& lhs, const Vec3& rhs);
    Vec3& Mul(const Vec3& lhs, const Vec3& rhs);
    Vec3& Div(const Vec3& lhs, const Vec3& rhs);
    Vec3& Mul(const Vec3& lhs, float rhs);
    Vec3& Div(const Vec3& lhs, float rhs);
    Vec3& Mad(const Vec3& lhsMul, float rhsMul, const Vec3& add);
    Vec3& Mul(const Mtx34& lhs, const Vec3& rhs);

    //
    static float Length(const Vec3& v);
    static float LengthSq(const Vec3& v);
    static float Distance(const Vec3& lhs, const Vec3& rhs);
    static float DistanceSq(const Vec3& lhs, const Vec3& rhs);
    static float Dot(const Vec3& lhs, const Vec3& rhs);
    Vec3& Cross(const Vec3& lhs, const Vec3& rhs);
    float Normalize(const Vec3& v);

    Vec3& Transform(const Mtx34& m, const Vec3& v);
    Vec3& Rotate(const Mtx34& m, const Vec3& v);
    Vec3& Rotate(const Quat& q, const Vec3& v);
    Vec3& Project(const Mtx44& m, const Vec3& v);
};

}}} // namespace nw::g3d::math

#include "inl/g3d_Vector3-inl.h"

#endif // NW_G3D_MATH_VECTOR3_H_
