﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_G3D_DEFS_H_
#define NW_G3D_DEFS_H_

//--------------------------------------------------------------------------------------------------
// バージョン

#define NW_G3D_VERSION_MAJOR            ( 4 )
#define NW_G3D_VERSION_MINOR            ( 5 )
#define NW_G3D_VERSION_MICRO            ( 0 )

#define NW_G3D_VERSION_BINARYBUGFIX     ( 3 )
#define NW_G3D_VERSION_SHADERBUGFIX     ( 4 )

//--------------------------------------------------------------------------------------------------
// プラットフォーム

#define NW_G3D_WIN_WIN                  ( 0x1 )
#define NW_G3D_CAFE_CAFE                ( 0x4 )
#define NW_G3D_CAFE_WIN                 ( 0x5 )
#if defined( ANDROID )
#define NW_G3D_ANDROID_ANDROID          ( 0x8 )
#endif
#if defined( __APPLE__ )
#define NW_G3D_IOS_IOS                  ( 0x10 )
#endif

#if defined( NW_G3D_PLATFORM )
// 定義されているものを使用
#elif defined( _WIN32 )
#define NW_G3D_PLATFORM                 ( NW_G3D_CAFE_WIN )
#elif defined( ANDROID )
#define NW_G3D_PLATFORM                 ( NW_G3D_ANDROID_ANDROID )
#elif defined( __APPLE__ )
#define NW_G3D_PLATFORM                 ( NW_G3D_IOS_IOS )
#else // CAFE
#define NW_G3D_PLATFORM                 ( NW_G3D_CAFE_CAFE )
#endif // NW_G3D_PLATFORM

// 実機の環境
#define NW_G3D_IS_TARGET_WIN            ( NW_G3D_PLATFORM == NW_G3D_WIN_WIN )
#define NW_G3D_IS_TARGET_CAFE           ( ( NW_G3D_PLATFORM | 1 ) == NW_G3D_CAFE_WIN )

// 現在動作している環境
#define NW_G3D_IS_HOST_WIN              ( NW_G3D_PLATFORM & 1 )
#define NW_G3D_IS_HOST_CAFE             ( NW_G3D_PLATFORM == NW_G3D_CAFE_CAFE )

//--------------------------------------------------------------------------------------------------
// エンディアン

#define NW_G3D_LITTLE_ENDIAN            ( 0 )
#define NW_G3D_BIG_ENDIAN               ( 1 )

// 実機のエンディアン
#if NW_G3D_IS_TARGET_CAFE
#define NW_G3D_TARGET_ENDIAN            ( NW_G3D_BIG_ENDIAN )
#else
#define NW_G3D_TARGET_ENDIAN            ( NW_G3D_LITTLE_ENDIAN )
#endif

// 現在動作している環境のエンディアン
#if NW_G3D_IS_HOST_WIN || defined(ANDROID) || defined(__APPLE__)
#define NW_G3D_HOST_ENDIAN              ( NW_G3D_LITTLE_ENDIAN )
#else
#define NW_G3D_HOST_ENDIAN              ( NW_G3D_TARGET_ENDIAN )
#endif

//--------------------------------------------------------------------------------------------------
// アーキテクチャ

#define NW_G3D_32BIT                    ( 2 )
#define NW_G3D_64BIT                    ( 3 )

// 実機のアーキテクチャ
#define NW_G3D_TARGET_ARCH              ( NW_G3D_32BIT )

#define NW_G3D_TARGET_PTRSIZE           ( 1 << NW_G3D_TARGET_ARCH )
#define NW_G3D_TARGET_DEFAULT_ALIGNMENT ( NW_G3D_TARGET_PTRSIZE )

// 現在動作している環境のアーキテクチャ
#if defined( _WIN64 )
#define NW_G3D_HOST_ARCH                ( NW_G3D_64BIT )
#else
#define NW_G3D_HOST_ARCH                ( NW_G3D_32BIT )
#endif

#define NW_G3D_HOST_PTRSIZE             ( 1 << NW_G3D_HOST_ARCH )
#define NW_G3D_HOST_DEFAULT_ALIGNMENT   ( NW_G3D_HOST_PTRSIZE )

//--------------------------------------------------------------------------------------------------
// ビルド

#define NW_G3D_DEBUG                    ( 1 )
#define NW_G3D_DEVELOP                  ( 2 )
#define NW_G3D_RELEASE                  ( 3 )

#if defined( NW_G3D_BUILD )
// 定義されているものを使用
#elif defined( NW_DEBUG )
#define NW_G3D_BUILD                    ( NW_G3D_DEBUG )
#elif defined( NW_DEVELOP )
#define NW_G3D_BUILD                    ( NW_G3D_DEVELOP )
#elif defined( NW_RELEASE )
#define NW_G3D_BUILD                    ( NW_G3D_RELEASE )
#else
#error "Unknown build"
#endif // NW_G3D_BUILD

#define NW_G3D_IS_DEBUG                 ( NW_G3D_BUILD == NW_G3D_DEBUG )
#define NW_G3D_IS_DEVELOP               ( NW_G3D_BUILD == NW_G3D_DEVELOP )
#define NW_G3D_IS_RELEASE               ( NW_G3D_BUILD == NW_G3D_RELEASE )

//--------------------------------------------------------------------------------------------------
// グラフィックス API

#define NW_G3D_IS_GX2                   ( NW_G3D_IS_HOST_CAFE )
#define NW_G3D_IS_GL                    ( !NW_G3D_IS_HOST_CAFE )

#if defined(ANDROID) || defined(__APPLE__)
#define NW_G3D_IS_GL_ES                 ( 1 )
#endif

//--------------------------------------------------------------------------------------------------
// インライン

#if NW_G3D_IS_HOST_WIN // WIN32 の場合のみ forceinline にする
#define NW_G3D_FORCE_INLINE __forceinline
#else
#define NW_G3D_FORCE_INLINE inline
#endif

#define NW_G3D_INLINE inline
#define NW_G3D_MATH_INLINE inline

//--------------------------------------------------------------------------------------------------
// アライメント

#if NW_G3D_IS_HOST_WIN
#define NW_G3D_ALIGN(alignment) __declspec(align(alignment))
#elif defined(ANDROID) || defined(__APPLE__)
#define NW_G3D_ALIGN(alignment) __attribute__((aligned(alignment)))
#elif NW_G3D_IS_HOST_CAFE
#define NW_G3D_ALIGN(alignment) ALIGNVAR(alignment)
#else
#error "Unknown platform"
#endif // NW_G3D_PLATFORM

//--------------------------------------------------------------------------------------------------
// 未使用変数

#define NW_G3D_UNUSED( var ) (void)var

//--------------------------------------------------------------------------------------------------
// 定数条件

#if defined( _MSC_VER )
#define NW_G3D_STATIC_CONDITION(exp) ((void)0, (exp))
#else
#define NW_G3D_STATIC_CONDITION(exp) (exp)
#endif

//--------------------------------------------------------------------------------------------------
// テーブル

#if NW_G3D_CONFIG_USE_STATIC
#define NW_G3D_TABLE_FIELD static const
#else
#define NW_G3D_TABLE_FIELD const
#endif

//--------------------------------------------------------------------------------------------------
// コード位置

#if defined( _MSC_VER )
#define NW_G3D_CODE_POSITION_NAME __FUNCTION__
#elif defined( __ghs__ )
#define NW_G3D_CODE_POSITION_NAME __BASE__
#elif defined( __clang__ )
#define NW_G3D_CODE_POSITION_NAME __FUNCTION__
#else
#define NW_G3D_CODE_POSITION_NAME ""
#endif

//--------------------------------------------------------------------------------------------------
// コピー禁止マクロ

#define NW_G3D_DISALLOW_COPY_AND_ASSIGN(TypeName) \
  /*! @briefprivate */                        \
  TypeName(const TypeName&);                      \
  /*! @briefprivate */                        \
  void operator=(const TypeName&)

//--------------------------------------------------------------------------------------------------
// 廃止予定マクロ

#if defined( __ghs__ )
  // Green Hills Software
  #define NW_G3D_DEPRECATED_FUNCTION_MSG(MFunc, msg) MFunc __attribute__ ((deprecated))

#elif defined( __clang__ )
  // Clang
  #define NW_G3D_DEPRECATED_FUNCTION_MSG(MFunc, msg) MFunc __attribute__ ((deprecated))

#elif defined( _MSC_VER )
  // Miscrosoft Visual C++
  #define NW_G3D_DEPRECATED_FUNCTION_MSG(MFunc, msg) __declspec(deprecated(msg)) MFunc
#else
  #error "Unknown compiler"
#endif

#if !defined(NW_G3D_DEPRECATED_FUNCTION)
  #if defined(NW_G3D_IGNORE_DEPRECATED)
    #define NW_G3D_DEPRECATED_FUNCTION(MFunc) MFunc
  #else
    #define NW_G3D_DEPRECATED_FUNCTION(MFunc) NW_G3D_DEPRECATED_FUNCTION_MSG(MFunc, \
        "## g3d deprecated function ##")
  #endif
#endif

#if defined(NW_DOCUMENTATION)
  #undef NW_G3D_DEPRECATED_FUNCTION
  #define NW_G3D_DEPRECATED_FUNCTION(MFunc) \
  /*! @details :deprecated */ MFunc
  #undef NW_G3D_DEPRECATED_FUNCTION_MSG
  #define NW_G3D_DEPRECATED_FUNCTION_MSG(MFunc, msg) \
  /*! @details :deprecated */ MFunc
#endif

//--------------------------------------------------------------------------------------------------
// バージョンマクロ

#if NW_G3D_HOST_ENDIAN == NW_G3D_LITTLE_ENDIAN

#define NW_G3D_MAKE_U8X4_AS_U32(a,b,c,d)    \
    static_cast<u32>(                       \
          (static_cast<u8>(a) <<  0)        \
        | (static_cast<u8>(b) <<  8)        \
        | (static_cast<u8>(c) << 16)        \
        | (static_cast<u8>(d) << 24)        \
    )

#define NW_G3D_GET_SIGNATURE0(sig) ((static_cast<u32>(sig) >>  0) & 0xFF)
#define NW_G3D_GET_SIGNATURE1(sig) ((static_cast<u32>(sig) >>  8) & 0xFF)
#define NW_G3D_GET_SIGNATURE2(sig) ((static_cast<u32>(sig) >> 16) & 0xFF)
#define NW_G3D_GET_SIGNATURE3(sig) ((static_cast<u32>(sig) >> 24) & 0xFF)

#else // NW_G3D_HOST_ENDIAN == NW_G3D_BIG_ENDIAN

#define NW_G3D_MAKE_U8X4_AS_U32(a,b,c,d)    \
    static_cast<u32>(                       \
          (static_cast<u8>(a) << 24)        \
        | (static_cast<u8>(b) << 16)        \
        | (static_cast<u8>(c) <<  8)        \
        | (static_cast<u8>(d) <<  0)        \
        )

#define NW_G3D_GET_SIGNATURE0(sig) ((static_cast<u32>(sig) >> 24) & 0xFF)
#define NW_G3D_GET_SIGNATURE1(sig) ((static_cast<u32>(sig) >> 16) & 0xFF)
#define NW_G3D_GET_SIGNATURE2(sig) ((static_cast<u32>(sig) >>  8) & 0xFF)
#define NW_G3D_GET_SIGNATURE3(sig) ((static_cast<u32>(sig) >>  0) & 0xFF)

#endif // NW_G3D_HOST_ENDIAN

#define NW_G3D_VERSION                  \
    NW_G3D_MAKE_U8X4_AS_U32(            \
        NW_G3D_VERSION_MAJOR,           \
        NW_G3D_VERSION_MINOR,           \
        NW_G3D_VERSION_MICRO,           \
        NW_G3D_VERSION_BINARYBUGFIX     \
    )

#define NW_G3D_SHADER_VERSION           \
    NW_G3D_MAKE_U8X4_AS_U32(            \
        NW_G3D_VERSION_MAJOR,           \
        NW_G3D_VERSION_MINOR,           \
        NW_G3D_VERSION_MICRO,           \
        NW_G3D_VERSION_SHADERBUGFIX     \
    )

//--------------------------------------------------------------------------------------------------
// 名前空間

namespace nw { namespace g3d {

namespace ut {}
using namespace nw::g3d::ut;

namespace math {}
using namespace nw::g3d::math;

namespace fnd {}
using namespace nw::g3d::fnd;

namespace res {}
using namespace nw::g3d::res;

}} // namespace nw::g3d

//--------------------------------------------------------------------------------------------------
// 基本型

#include <cafe/os/OSCore.h> // $CAFE_ROOT/system/include を参照

typedef u8 bit8;
typedef u16 bit16;
typedef u32 bit32;
typedef u64 bit64;

typedef unsigned int uint;

#if NW_G3D_IS_HOST_CAFE
#include <stdint.h>
#include <ppc_ghs.h>
#include <ppc_ps.h>
#elif defined(ANDROID)
typedef u16 char16;
#else
typedef wchar_t char16;
#endif // NW_G3D_PLATFORM

//---------------------------------------------------------------------------------------------------
// プラグマ用マクロ

// コンパイラの警告レベルを退避します。
#if defined( _MSC_VER ) && _MSC_VER >= 1900
#define NW_G3D_PRAGMA_PUSH_WARNINGS __pragma( warning( push ) )
#else
#define NW_G3D_PRAGMA_PUSH_WARNINGS
#endif

// コンパイラの警告レベルを復帰します。
#if defined( _MSC_VER ) && _MSC_VER >= 1900
#define NW_G3D_PRAGMA_POP_WARNINGS __pragma( warning( pop ) )
#else
#define NW_G3D_PRAGMA_POP_WARNINGS
#endif

// 変数隠蔽の警告を抑制します。
#if defined( _MSC_VER ) && _MSC_VER >= 1900
#define NW_G3D_DISABLE_WARNING_SHADOW \
    __pragma( warning( disable:4456 ) ) \
    __pragma( warning( disable:4457 ) ) \
    __pragma( warning( disable:4458 ) ) \
    __pragma( warning( disable:4459 ) )
#else
#define NW_G3D_DISABLE_WARNING_SHADOW
#endif

// 変数キャストの警告を抑制します。
#if defined( _MSC_VER ) && _MSC_VER >= 1900
#define NW_G3D_DISABLE_WARNING_REINTERPRET_CAST \
    __pragma( warning( disable:4302 ) ) \
    __pragma( warning( disable:4311 ) ) \
    __pragma( warning( disable:4312 ) )
#else
#define NW_G3D_DISABLE_WARNING_REINTERPRET_CAST
#endif

#endif // NW_G3D_DEFS_H_
