﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_G3D_CONFIG_H_
#define NW_G3D_CONFIG_H_

#if !defined(NW_DEBUG) && !defined(NW_DEVELOP) && !defined(NW_RELEASE)
#error "Build target is not defined."
#endif

#include <cstddef>
#include <cstdlib>
#include <new>

#define NW_G3D_CONFIG_USE_STATIC 1

#define NW_G3D_PERF_ENABLE 1
#define NW_G3D_PERF_LEVEL 0 // 0 はレベル指定の測定を無効にします。

#define NW_G3D_FORCE_PPC_SYNC 0 // 1 は常に同期版のデータキャッシュ操作関数を使用します。

#define NW_G3D_GFXSHADER_SETUPARG_CONSTRUCTOR 1

#define NW_G3D_USE_COMPUTE_SHADER 1

#define NW_G3D_MAX_SHADER_KEY 32 // シェーダキーの最大長です

#include <nw/g3d/g3d_defs.h>

#include <sdk_ver.h>
#if NW_G3D_IS_GX2
#include <cafe/gx2.h>
#endif

#include <nw/g3d/g3d_assert.h>

#endif // NW_G3D_CONFIG_H_
