﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_G3D_SHADERUTILITY_H_
#define NW_G3D_SHADERUTILITY_H_

#include <nw/g3d/g3d_config.h>

namespace nw { namespace g3d {

namespace res {

class ResMaterial;
class ResSampler;
class ResVertex;
class ResVtxAttrib;
class ResShaderAssign;
class ResShadingModel;

} // namespace res

class MaterialObj;
class ShadingModelObj;

class ShaderUtility
{
public:

    //! @brief シェーダアサインに記録された情報を元にシェーダキーを初期化します。
    //!
    //! materialPass を true にするとシェーダとマテリアルの設定が一致していない場合に
    //! 警告を表示します。
    //!
    static void InitShaderKey(bit32* pKey, int keyLength,
        const ResShadingModel* pResShadingModel, const ResShaderAssign* pResShaderAssign,
        bool materialPass = true);

    //! @brief シェーダアサインに記録された情報を元にシェーダキーを初期化します。
    //!
    //! materialPass を true にするとシェーダとマテリアルの設定が一致していない場合に
    //! 警告を表示します。
    //!
    static void InitShaderKey(
        ShadingModelObj* pShadingModelObj, const ResShaderAssign* pResShaderAssign,
        bool materialPass = true);

    //! @brief マテリアルにシェーディングモデルを関連付けます。
    //!
    //! シェーダパラメータを書き込む UniformBlock のサイズと
    //! 個々のシェーダパラメータのオフセットをマテリアルに記録します。
    //!
    static void BindShaderParam(ResMaterial* pResMaterial, const ResShadingModel* pResShadingModel);

    //! @brief マテリアルをシェーディングモデルで初期化します。
    //!
    //! シェーダパラメータを書き込む UniformBlock の初期値を書き込みます。
    //!
    static void InitShaderParam(MaterialObj* pMaterialObj, const ResShadingModel* pResShadingModel);
};

}} // namespace nw::g3d

#endif // NW_G3D_SHADERUTILITY_H_
