﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_G3D_FND_EGLUTILITY_H_
#define NW_G3D_FND_EGLUTILITY_H_

#include <nw/g3d/g3d_config.h>

#if defined(ANDROID)

#include <EGL/egl.h>
#include <GLES/gl.h>
#include <android_native_app_glue.h>

namespace nw { namespace g3d { namespace fnd { namespace detail {

bool       CreateGLContext(const struct android_app* app);
void       DeleteGLContext();
EGLDisplay GetEGLDisplay();
void       SwapBuffer();
int32_t    GetWidth();
int32_t    GetHeight();

}}}} // namespace nw::g3d::fnd::detail

#endif

#endif // NW_G3D_FND_EGLUTILITY_H_
