﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_G3D_H_
#define NW_G3D_H_

#include <nw/g3d/g3d_res.h>
#include <nw/g3d/g3d_math.h>
#include <nw/g3d/g3d_fnd.h>

// 明示的にエディタ連携を有効にするため
// 使用する場合はアプリケーションで g3d_edit.h を include する。
// #include <nw/g3d/g3d_edit.h>

#include <nw/g3d/ut/g3d_Perf.h>

#include <nw/g3d/g3d_ModelObj.h>
#include <nw/g3d/g3d_SkeletonObj.h>
#include <nw/g3d/g3d_ShapeObj.h>
#include <nw/g3d/g3d_MaterialObj.h>

#include <nw/g3d/g3d_AnimObj.h>
#include <nw/g3d/g3d_SkeletalAnimObj.h>
#include <nw/g3d/g3d_ShaderParamAnimObj.h>
#include <nw/g3d/g3d_TexPatternAnimObj.h>
#include <nw/g3d/g3d_VisibilityAnimObj.h>
#include <nw/g3d/g3d_ShapeAnimObj.h>
#include <nw/g3d/g3d_SceneAnimObj.h>

#include <nw/g3d/g3d_ShaderUtility.h>
#include <nw/g3d/g3d_ShaderObj.h>

#include <nw/g3d/g3d_Billboard.h>

//! @namespace nw::g3d
//! @brief グラフィックスのランタイムライブラリの名前空間です。

//! @namespace nw::g3d::fnd
//! @brief 低レイヤーグラフィックス用の名前空間です。nw::g3d から using されています。

//! @namespace nw::g3d::res
//! @brief リソース用の名前空間です。nw::g3d から using されています。

//! @namespace nw::g3d::edit
//! @brief エディタ連携用の名前空間です。

//! @namespace nw::g3d::ut
//! @brief 内部ユーティリティ用の名前空間です。互換性や動作の保証はありません。

//! @namespace nw::g3d::math
//! @brief 内部ユーティリティ用の名前空間です。互換性や動作の保証はありません。

//! @namespace nw::g3d::edit::ut
//! @brief 内部ユーティリティ用の名前空間です。互換性や動作の保証はありません。

#endif // NW_G3D_H_
