﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_FONT_TYPES_H_
#define NW_FONT_TYPES_H_

#if defined(_MSC_VER) && _MSC_VER >= 1500
#pragma once
#endif

#include <nw/types.h>
#include <nw/ut/ut_Color.h>
#include <nw/font/font_DrawerTypes.h>

namespace nw {
namespace font {

enum
{
    //! リソースの先頭アドレスの必要アライメント数です。
    RESOURCE_ALIGNMENT = 8192,
};

namespace internal {

enum
{
    VERTEX_ATTR_POS,
    VERTEX_ATTR_POS_Z,
    VERTEX_ATTR_COLOR,
    VERTEX_ATTR_TEXCOORD,

    VERTEX_ATTR_NUM
};

enum
{
    POS_X,
    POS_Y,

    POS_NUM
};

enum
{
    COLOR_R,
    COLOR_G,
    COLOR_B,
    COLOR_A,

    COLOR_NUM
};

enum
{
    TEXCOORD_X,
    TEXCOORD_Y,

    TEXCOORD_NUM
};

enum
{
    TRIFAN_VTX_RT,
    TRIFAN_VTX_LT,
    TRIFAN_VTX_LB,
    TRIFAN_VTX_RB,

    TRIFAN_VTX_MAX
};

enum
{
    LOC_PROJECTION,
    LOC_MODELVIEW,

    LOC_FRAGMENTLIGHTING_ENABLED,
    LOC_TEXTURE0_SAMPLERTYPE,
    LOC_FOG_MODE,
    LOC_FRAGOPERATION_ENABLEALPHATEST,

    LOC_MAX
};

enum
{
    TCLOC_SRCRGB,
    TCLOC_SRCALPHA,
    TCLOC_OPERANDRGB,
    TCLOC_OPERANDALPHA,
    TCLOC_COMBINERGB,
    TCLOC_COMBINEALPHA,
    TCLOC_SCALERGB,
    TCLOC_SCALEALPHA,
    TCLOC_CONSTRGBA,

    TCLOC_MAX
};

enum
{
    TEXENV_3,
    TEXENV_4,
    TEXENV_5,

    TEXENV_MAX
};

enum TextColor
{
    TEXTCOLOR_START,        //!< テキストのグラデーション開始色です。
    TEXTCOLOR_END,          //!< テキストのグラデーション終了色です。

    TEXTCOLOR_MAX           //!< 列挙子の総数です。
};

//! 1文字当たりに必要な頂点インデックスの数
const int               VERTEX_INDEX_NUM = 6;

struct VertexAttribute
{
    f32                 pos[POS_NUM];
    ut::Color4u8          color;
    f32                 tex[TEXCOORD_NUM];
};

}   // namespace internal
}   // namespace font
}   // namespace nw

#endif //  NW_FONT_TYPES_H_
