﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_FONT_DRAWERTYPES_H_
#define NW_FONT_DRAWERTYPES_H_

#if defined(_MSC_VER) && _MSC_VER >= 1500
#pragma once
#endif

#include <nw/types.h>

namespace nw {
namespace font {

//---------------------------------------------------------------------------
//! @brief ペインの四隅に設定された頂点座標にアクセスするときに使用します。
//!
//! @since 2009/09/18 初版。
//---------------------------------------------------------------------------
enum PaneVertex
{
    //! 左上隅の頂点座標です。
    VERTEX_LT,
    //! 右上隅の頂点座標です。
    VERTEX_RT,
    //! 左下隅の頂点座標です。
    VERTEX_LB,
    //! 右下隅の頂点座標です。
    VERTEX_RB,

    //! 列挙子の総数です。
    VERTEX_MAX
};

}   // namespace font
}   // namespace nw

#endif //  NW_FONT_DRAWERTYPES_H_
