﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/eftvw2_String.h>
#include <nw/eft/eftvw2_Preview.h>

//------------------------------------------------------------------------------
namespace nw {
namespace eftvw2 {

//---------------------------------------------------------------------------
//! @brief        ユーザーモデルプレビューです。
//---------------------------------------------------------------------------
class UsrModelPreview : public nw::eftvw2::Preview
{
public:
    //---------------------------------------------------------------------------
    //! @brief        UsrModelPreviewクラスのインスタンスを生成します。
    //! @param[in] eftHeap     TBD
    //! @param[in] guid     TBD
    //! @param[in] modelName     TBD
    //! @param[in] modelEnumrator     TBD
    //! @return TBD
    //---------------------------------------------------------------------------
    static UsrModelPreview* CreateUsrModelPreview( nw::eft2::Heap* eftHeap, eftcom::Guid guid, const char* modelName, IEftModelEnumerator* modelEnumrator )
    {
        // クラスの生成を行います。
        void* buffer = eftHeap->Alloc( sizeof(UsrModelPreview) );
        if( !buffer) return NULL;
        UsrModelPreview* usrModelPreview = new (buffer) UsrModelPreview( EFT_VWR_PRV_USR_MODEL, modelName, modelEnumrator );

        // TODO: Initialize()の引数をチェックする必要がる
        // プレビューを初期化します。
        usrModelPreview->Initialize( eftHeap, EFT_VWR_PRV_USR_MODEL, guid );

        return usrModelPreview;
    }

    //---------------------------------------------------------------------------
    //! @brief        UsrModelPreviewクラスのインスタンスを破棄します。
    //! @param[in] eftHeap     TBD
    //! @param[in] modelPreview     TBD
    //---------------------------------------------------------------------------
    static void DestroyUsrModelPreview( nw::eft2::Heap* eftHeap, UsrModelPreview* modelPreview )
    {
        if ( modelPreview )
        {
            eftHeap->Free( modelPreview );
        }
    }

private:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //! @param[in] type     TBD
    //! @param[in] modelName     TBD
    //! @param[in] modelEnumerator     TBD
    //---------------------------------------------------------------------------
    UsrModelPreview( EftPreviewType type, const char* modelName, IEftModelEnumerator* modelEnumerator ) : Preview()
    {
        EFT_UNUSED_VARIABLE( type );
        m_PreviewName.Copy( modelName );
        mModelEnumerator = modelEnumerator;
    }

    //---------------------------------------------------------------------------
    //! @brief        マトリクスを取得します。
    //! @param[in] matrix     TBD
    //! @param[in] idx     TBD
    //---------------------------------------------------------------------------
    virtual void GetMatrix( nw::math::MTX34* matrix, s32 idx )
    {
        //nw::math::Matrix34 rootMatrix;
        //nw::math::Matrix34 boneMatrix;
        //mModelEnumerator->GetModelRootMtx( &rootMatrix, m_PreviewName.Cstr() );
        //mModelEnumerator->GetBoneMtx( &boneMatrix, m_PreviewName.Cstr(), idx );
        //matrix->SetMult( rootMatrix, boneMatrix );

        mModelEnumerator->GetBoneMtx( matrix, m_PreviewName.Cstr(), idx );
    }

private:
    IEftModelEnumerator*    mModelEnumerator;   //!< TBD
    VwrString               m_PreviewName;      //!< プレビュー名
};

//------------------------------------------------------------------------------
} // namespace eftvw2
} // namespace nw
