﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/eftvw2_Preview.h>


namespace nw     {
namespace eftvw2 {

//---------------------------------------------------------------------------
//! @brief  モデルプレビュークラスです。
//---------------------------------------------------------------------------
class ModelPreview : public Preview
{
public:

    //----------------------------------------
    //! @name 初期化/終了 処理
    //@{

    //---------------------------------------------------------------------------
    //! @brief  コンストラクタです。
    //---------------------------------------------------------------------------
    ModelPreview();

    //@}


    //----------------------------------------
    //! @name 取得/設定 処理
    //@{

    //---------------------------------------------------------------------------
    //! @brief        モデルプレビューリソースを設定します。
    //!
    //! @param[in]    resource モデルプレビューリソース。
    //---------------------------------------------------------------------------
    void SetResModelPreview( const ResModelPreview* resource )
    {
        mResModelPreview = *resource;
        mIsSetResModelPreview = true;
    }

    //---------------------------------------------------------------------------
    //! @brief        モデルプレビューリソースを取得します。
    //!
    //! @return       モデルプレビューリソースを返します。
    //---------------------------------------------------------------------------
    ResModelPreview* GetResModelPreview() { return &mResModelPreview; }

    //---------------------------------------------------------------------------
    //! @brief        描画のOn/Offを状態を取得します。
    //! @return       描画のOn/Off状態
    //---------------------------------------------------------------------------
    bool IsVisible() const { return mIsVisible; }

    //---------------------------------------------------------------------------
    //! @brief                  描画のOn/Offを設定します。
    //! @param[in]    visible   描画のOn/Off指定
    //---------------------------------------------------------------------------
    void SetVisible( bool visible ) { mIsVisible = visible; };

    //@}


protected:
    ResModelPreview mResModelPreview;        //!< モデルプレビューリソース
    bool            mIsSetResModelPreview;   //!< モデルプレビューリソースがセットされたか？
    bool			mIsVisible;              //!< モデルの描画フラグ
};

} // namespace eftvw2
} // namespace nw
