﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/eft2_System.h>

//------------------------------------------------------------------------------
namespace nw {
namespace eftvw2 {

class Preview;

//---------------------------------------------------------------------------
//! @brief        エフェクトファンクションです。
//---------------------------------------------------------------------------
class Function
{
    friend class Preview;

public:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    Function();

    //---------------------------------------------------------------------------
    //! @brief        デストラクタです。
    //---------------------------------------------------------------------------
    virtual ~Function() {}

    //---------------------------------------------------------------------------
    //! @brief        初期化処理です。
    //! @param[in] eftHeap     TBD
    //! @param[in] preview     TBD
    //---------------------------------------------------------------------------
    void Initialize( nw::eft2::Heap* eftHeap, Preview* preview );

    //---------------------------------------------------------------------------
    //! @brief        終了処理です。
    //---------------------------------------------------------------------------
    void Finalize();

    //---------------------------------------------------------------------------
    //! @brief        パラメータをセットします。
    //! @param[in] param     TBD
    //! @param[in] paramSize     TBD
    //---------------------------------------------------------------------------
    void SetFunctionParam( void* param, u32 paramSize );

    //---------------------------------------------------------------------------
    //! @brief        指定IDのファンクションを保持するか？
    //! @param[in] functionId     TBD
    //! @return TBD
    //---------------------------------------------------------------------------
    bool HasFunction( u32 functionId );

    //---------------------------------------------------------------------------
    //! @brief        計算処理です。
    //! @param[in] view     TBD
    //---------------------------------------------------------------------------
    virtual void Calc( const nw::math::MTX34& view );

private:
    nw::eft2::Heap*         mEftHeap;   //!< TBD
    Preview*                mPreview;   //!< TBD
};

//------------------------------------------------------------------------------
} // namespace eftvw2
} // namespace nw
