﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#if EFT_IS_CAFE
#include <types.h>
#endif
#include <types.h>

#include <nw/ut/ut_Memory.h>
#include <nw/ut/ut_List.h>
#include <nw/ut/os/ut_Thread.h>
#include <nw/ut/os/ut_Mutex.h>

namespace nw   {
namespace eftvw2 {

typedef int (*TaskFunc)( int intParam, void* ptrParam );

//---------------------------------------------------------------------------
//! @briefprivate      タスクオブジェクトです。
//---------------------------------------------------------------------------
struct TaskObj
{
    TaskFunc     func;      //!< タスクメイン関数です。
    int          intParam;  //!< 整数パラメータ引数です。
    void*        ptrParam;  //!< ポインタパラメータ引数です。
    nw::ut::Link link;      //!< リンクです。

    //---------------------------------------------------------------------------
    //! @brief       Task オブジェクトを初期化します。
    //!
    //! @param[in]   function       VTask関数です。
    //! @param[in]   intParamValue  整数パラメータ引数です。
    //! @param[in]   ptrParamValue  ポインタパラメータ引数です。
    //---------------------------------------------------------------------------
    void Init( TaskFunc function, int intParamValue, void* ptrParamValue)
    {
        this->func     = function;
        this->intParam = intParamValue;
        this->ptrParam = ptrParamValue;
    }
};


//---------------------------------------------------------------------------
//! @briefprivate     タスクベースクラスです。
//---------------------------------------------------------------------------
class TaskBase : public nw::ut::ThreadHandler
{
public:
    //---------------------------------------------------------------------------
    //! @brief       Task オブジェクトを追加します。
    //!
    //! @param[out]  task    追加する Task オブジェクトです。
    //---------------------------------------------------------------------------
    void AddTask( TaskObj* task )
    {
        m_Task = task;
    }

    //---------------------------------------------------------------------------
    //! @brief       Task オブジェクトを削除します。
    //!
    //! @param[out]  task    削除する Task オブジェクトです。
    //---------------------------------------------------------------------------
    void RemoveTask( TaskObj* task )
    {
        EFT_UNUSED_VARIABLE( task );

        m_Task = NULL;
    }
    //---------------------------------------------------------------------------
    //! @brief       TBD
    //! @param[in] Arg     TBD
    //! @return TBD
    //---------------------------------------------------------------------------
    bool CreateThread(nw::ut::Thread::CreateArg &Arg)
    {
        if ( m_Thread )
        {
    		return m_Thread->Create( Arg );
        }
        else
        {
            return false;
        }
    }

    //---------------------------------------------------------------------------
    //! @brief       TBD
    //! @return TBD
    //---------------------------------------------------------------------------
    s32 GetPriority()
    {
        return m_Thread->GetPriority();
    }

    //---------------------------------------------------------------------------
    //! @brief       TBD
    //! @param[in] priority     TBD
    //---------------------------------------------------------------------------
    void  SetPriority(s32 priority)
    {
        m_Thread->SetPriority(priority);
    }

    //---------------------------------------------------------------------------
    //! @brief       TBD
    //---------------------------------------------------------------------------
    void Start()
    {
        m_Thread->Resume();
    }

    //---------------------------------------------------------------------------
    //! @brief       TBD
    //---------------------------------------------------------------------------
    void Stop()
    {
        m_Thread->Join();
    }

    //---------------------------------------------------------------------------
    //! @brief       TBD
    //! @param[in] stackBase     TBD
    //! @param[in] stackSize     TBD
    //---------------------------------------------------------------------------
    void SetStack(void **stackBase, u32 *stackSize)
    {
        *stackBase = (void *)m_ThreadStack;
        *stackSize = sizeof(m_ThreadStack);
    }

    //---------------------------------------------------------------------------
    //! @brief       TBD
    //---------------------------------------------------------------------------
    void ThreadHandlerProc()
    {

        if (m_Task)
        {
            m_Task->func(m_Task->intParam, m_Task->ptrParam);

        }
    }
    //---------------------------------------------------------------------------
    //! @brief       コンストラクタです。
    //---------------------------------------------------------------------------
    /* ctor */ TaskBase()
        : nw::ut::ThreadHandler()
        , m_Thread( NULL )
        , m_ThreadStarted( false )
        , m_CreatedCount( 0 )
        , m_Task( NULL)
    {
        m_Thread = new nw::ut::Thread( this );
    }

    //---------------------------------------------------------------------------
    //! @brief       デストラクタです。
    //---------------------------------------------------------------------------
    virtual ~TaskBase()
    {
        delete m_Thread;
    }

    //---------------------------------------------------------------------------
    //! @brief       スレッドから呼ばれる関数です。
    //---------------------------------------------------------------------------
    //  virtual void ThreadHandlerProc() {}

    nw::ut::Thread* m_Thread;                             //!< バックグラウンドスレッドオブジェクト
    u32             m_ThreadStack[ 8192 / sizeof(u32) ];  //!< スタックサイズは固定
    nw::ut::Mutex   m_Mutex;                              //!< タスクリストの排他用オブジェクト
    nw::ut::List    m_TaskList;                           //!< タスクリスト
    bool            m_ThreadStarted;                      //!< スレッド開始フラグ

    int             m_CreatedCount;                       //!< 参照カウント
    TaskObj*        m_Task;                               //!< TBD
};

} // namespace eftvw2
} // namespace nw
