﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//---------------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------------
#include <nw/eft/eft2_EndianUtil.h>


namespace nw     {
namespace eftcom {

//--------------------------------------------------------------------------------------------
//! @brief      メッセージです.
//--------------------------------------------------------------------------------------------
struct Message
{
    unsigned int type;          //!< メッセージタイプです.
    unsigned int bufferSize;    //!< メッセージデータのサイズです.
};

//--------------------------------------------------------------------------------------------
//! @brief      メッセージ情報です.
//--------------------------------------------------------------------------------------------
struct MessageInfo
{
    int            packetSize;  //!< パケット全体のサイズです.
    unsigned short numPacket;   //!< パケット数です.
    unsigned short processID;   //!< プロセスIDです.(送信順番を判定するために使用します).
};

} // namespace eftcom
} // namespace nw
