﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nw     {
namespace eftcom {

//--------------------------------------------------------------------------------------------
//! @brief      GUIDです.
//--------------------------------------------------------------------------------------------
struct Guid
{
    unsigned char data[ 16 ];   //!< GUIDの値です.

    //----------------------------------------------------------------------------------------
    //! @brief      TBD
    //----------------------------------------------------------------------------------------
    enum
    {
        GUID_STRING_BUFF_SIZE = 64   //!< GUIDを文字列に変換時のバッファサイズ
    };

    //----------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //----------------------------------------------------------------------------------------
    Guid();

    //----------------------------------------------------------------------------------------
    //! @brief      引数付きコンストラクタです.
    //!
    //! @param [in]     dat         GUIDの値です.
    //! @return TBD
    //----------------------------------------------------------------------------------------
    Guid( unsigned char dat[16] );

    //----------------------------------------------------------------------------------------
    //! @brief      代入演算子です.
    //!
    //! @param [in]     value       代入する値です.
    //! @return TBD
    //----------------------------------------------------------------------------------------
    Guid& operator  = ( const Guid& value );

    //----------------------------------------------------------------------------------------
    //! @brief      等価比較演算子です.
    //!
    //! @param [in]     value       比較する値です.
    //! @return TBD
    //----------------------------------------------------------------------------------------
    bool  operator == ( const Guid& value ) const;

    //----------------------------------------------------------------------------------------
    //! @brief      非等価比較演算子です.
    //!
    //! @param [in]     value       比較する値です.
    //! @return TBD
    //----------------------------------------------------------------------------------------
    bool  operator != ( const Guid& value ) const;

    //----------------------------------------------------------------------------------------
    //! @brief      文字列に変換します.
    //! @param[in] text     TBD
    //! @param[in] size     TBD
    //! @return TBD
    //----------------------------------------------------------------------------------------
    char* GetString( char* text, unsigned int size );
};


} // namespace eftcom
} // namespace nw
