﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nw   {
namespace eft2 {

class Heap;

//---------------------------------------------------------------------------
//! @brief  頂点バッファ
//---------------------------------------------------------------------------
struct VertexBuffer
{
public:
    //---------------------------------------------------------------------------
    //! @brief  初期化
    //---------------------------------------------------------------------------
    void Initialize();

    //---------------------------------------------------------------------------
    //! @brief  終了処理
    //! @param[in] heap     TBD
    //---------------------------------------------------------------------------
    void Finalize( Heap* heap );

    //---------------------------------------------------------------------------
    //! @brief  バッファを確保します。
    //! @param[in] heap     TBD
    //! @param[in] size     TBD
    //! @param[in] element     TBD
    //! @return TBD
    //---------------------------------------------------------------------------
    void* AllocateVertexBuffer( Heap* heap, u32 size, u32 element );

    //---------------------------------------------------------------------------
    //! @brief  バッファを設定します。
    //! @param[in] buffer     TBD
    //! @param[in] size     TBD
    //! @param[in] element     TBD
    //---------------------------------------------------------------------------
    void SetVertexBuffer( void* buffer, u32 size, u32 element );

    //---------------------------------------------------------------------------
    //! @brief  バッファを取得します。
    //! @return TBD
    //---------------------------------------------------------------------------
    void* GetVertexBuffer() const { return m_VertexBuffer; }

    //---------------------------------------------------------------------------
    //! @brief  バッファサイズを取得します。
    //! @return TBD
    //---------------------------------------------------------------------------
    u32 GetVertexBufferSize() const { return m_VertexBufferSize; }

    //---------------------------------------------------------------------------
    //! @brief  頂点バッファを有効化します。
    //---------------------------------------------------------------------------
    void Validate();

    //---------------------------------------------------------------------------
    //! @brief  バッファをバインドします。
    //! @param[in] index     TBD
    //! @param[in] size     TBD
    //! @param[in] stride     TBD
    //---------------------------------------------------------------------------
    void BindBuffer( u32 index, u32 size, u32 stride ) const;

    //---------------------------------------------------------------------------
    //! @brief  バッファをバインドします。
    //! @param[in] index     TBD
    //! @param[in] start     TBD
    //! @param[in] size     TBD
    //! @param[in] stride     TBD
    //---------------------------------------------------------------------------
    void BindBuffer( u32 index, u32 start, u32 size, u32 stride );

    //---------------------------------------------------------------------------
    //! @brief  外部からのバッファをバインドします。
    //! @param[in] index     TBD
    //! @param[in] size     TBD
    //! @param[in] element     TBD
    //! @param[in] stride     TBD
    //! @param[in] buffer     TBD
    //---------------------------------------------------------------------------
    static void BindExtBuffer( u32 index, u32 size, u32 element, u32 stride, void* buffer );

private:
    u32             m_VertexElement;        //!< TBD
    u32             m_VertexBufferSize;     //!< TBD
    void*           m_VertexBuffer;         //!< TBD
    bool            m_IsValidate;           //!< TBD
};

} // namespace nw
} // namespace eft2
