﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/typeDef2.h>

namespace nw   {
namespace eft2 {

//---------------------------------------------------
//! @brief エフェクト専用のヒープクラスです。
//!
//! メモリ確保、メモリ解放メソッドを派生クラスにて実装する必要があります。
//! エフェクトシステム生成時に渡す、nw::eft::Config に実体を設定する必要があります。
//---------------------------------------------------
class Heap
{
public:
    //----------------------------------------
    //! @name コンストラクタ
    //@{

    //---------------------------------------------------------------------------
    //! @brief        メモリ管理を行う為のインターフェースクラスです。
    //!
    //!               各ご使用の環境に合わせて派生クラス側にて実装をお願いします。
    //---------------------------------------------------------------------------
    Heap(){}

    //---------------------------------------------------------------------------
    //! @brief        デストラクタです。
    //---------------------------------------------------------------------------
    virtual ~Heap() {}

    //@}


    //----------------------------------------
    //! @name メモリ確保/破棄
    //@{

    //! @brief メモリ確保時のアライメントです。
    enum Alignment
    {
        EFT_HEAP_DEAFULT_ALIGNMENT = 128    //!< デフォルトのアライメントサイズ
    };

    //---------------------------------------------------------------------------
    //! @brief                  メモリ確保を行います。
    //!                         各ご使用の環境に合わせて派生クラス側にて実装をお願いします。
    //! @param[in] size         確保するメモリサイズ
    //! @param[in] alignment    アライメント
    //! @return                 確保したメモリ領域へのポインタ
    //---------------------------------------------------------------------------
    virtual void* Alloc( u32 size, s32 alignment = EFT_HEAP_DEAFULT_ALIGNMENT ) = 0;

    //---------------------------------------------------------------------------
    //! @brief          メモリ破棄を行います。
    //!
    //!                 各ご使用の環境に合わせて派生クラス側にて実装をお願いします。
    //! @param[in] ptr  破棄するメモリアドレス
    //---------------------------------------------------------------------------
    virtual void Free( void* ptr ) = 0;

    //@}
};

} // namespace eft2
} // namespace nw
