﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DW_LOG_VIEWER_WINDOW_H_
#define NW_DW_LOG_VIEWER_WINDOW_H_

#include <nw/types.h>
#include <nw/dw/window/dw_Window.h>

namespace nw {
namespace internal {
namespace dw {

class LogViewerWindow : public Window
{
  public:
    LogViewerWindow();
    virtual ~LogViewerWindow();

    void AssignBuffer( void* buffer, unsigned long bufferSize, int width );
    void ReleaseBuffer();

    void PutString( const char* str );
    void Printf( const char* format, ... );

private:
    void VPrintf( const char* format, std::va_list vlist );

    // ScopedLock に必要な実装
public:
    typedef ut::ScopedLock<LogViewerWindow> SelfLock;
    void Lock() { m_IsLocking = true; }
    void Unlock() { m_IsLocking = false; }

private:
    static const int DEFAULT_TEXT_SCALE = -1;

    virtual void OnDraw( IUIRenderContext& context, UIRenderer& renderer );
    virtual void OnUpdateInputs(const nw::internal::dw::Inputs& inputs);

    void SetAutoScroll( bool enable ) { m_AutoScrollFlag = enable; }
    char* GetTextPtr( int line, int xPos );
    unsigned long PutChar( const char* str, char* dstPtr );
    char* NextLine();
    int GetLineCount();

    bool m_AutoScrollFlag;

    void* m_Buffer;
    unsigned long m_BufferSize;
    int m_Width;
    int m_LineMax;

    int m_RingTop;
    int m_PrintTop;
    int m_PrintXPos;

    int m_TextScale;
    f32 m_Y;
    int m_CyChar;

    float m_AccelVertOrigin;

    bool m_IsLocking;
};

} // namespace nw::internal::dw
} // namespace nw::internal
} // namespace nw

#endif // NW_DW_LOG_VIEWER_WINDOW_H_
