﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief 矩形の四辺の長さを示します。
//---------------------------------------------------------------------------
struct Thickness
{
    Thickness();
    /* implicit */ Thickness(float value);
    Thickness(float x, float y);
    Thickness(float left, float top, float right, float bottom);
    Thickness(const Thickness& value);

    void Set(float left, float top, float right, float bottom);

    float GetWidth() const;
    float GetHeight() const;

    Thickness& operator += (const Thickness& value);
    Thickness& operator -= (const Thickness& value);

    float left;
    float top;
    float right;
    float bottom;
};

const Thickness operator + (const Thickness& leftValue, const Thickness& rightValue);
const Thickness operator - (const Thickness& leftValue, const Thickness& rightValue);

const bool operator == (const Thickness& leftValue, const Thickness& rightValue);
const bool operator != (const Thickness& leftValue, const Thickness& rightValue);

} // dw
} // internal
} // nw
