﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dev/dev_PrimitiveRenderer.h>
#include <nw/dw/system/dw_UIRenderer.h>
#include <nw/dw/system/dw_NwTextRenderer.h>

namespace nw {
namespace internal {
namespace dw {

class NwUIRenderer : public UIRenderer
{
public:
    NwUIRenderer();

public:
    nw::dev::PrimitiveRenderer* GetPrimitiveRenderer() const;
    void SetPrimitiveRenderer(nw::dev::PrimitiveRenderer* value);

    NwTextRenderer* GetTextWriter() const;
    void SetTextRenderer(NwTextRenderer* value);

    /* override */ void BeginDraw();
    /* override */ void EndDraw();
    /* override */ void ClearBuffer();

protected:
    /*override*/ void DrawLineInternal(const IUIRenderContext* pRenderContext, const DrawLineArgs& arg);
    /*override*/ void DrawLineInternal(const IUIRenderContext* pRenderContext, const DrawMultiLineArgs& arg);
    /*override*/ void DrawRectangleInternal(const IUIRenderContext* pRenderContext, const DrawRectangleArgs& arg);
    /*override*/ void FillRectangleInternal(const IUIRenderContext* pRenderContext, const DrawRectangleArgs& arg);
    /*override*/ void DrawTextureInternal(const IUIRenderContext* pRenderContext, const DrawRectangleArgs& arg);
    /*override*/ void DrawTextInternal(const IUIRenderContext* pRenderContext, const DrawTextArgs& arg, const char* pText);
    /*override*/ void DrawTextFormatInternal(const IUIRenderContext* pRenderContext, const DrawTextArgs& arg, const char* pFormat, va_list valist);
    /*override*/ nw::math::Vector2 MeasureTextInternal(const DrawTextArgs& arg, const char* pText);
    /*override*/ nw::math::Vector2 MeasureTextFormatInternal(const DrawTextArgs& arg, const char* pFormat, va_list valist);

    /*override*/ State ChangeState(State state);

private:
    void SetIdle();
    void PrepareTransformMatrix();

private:
    nw::dev::PrimitiveRenderer* m_pPrimitiveRenderer;
    NwTextRenderer* m_pTextRenderer;
};

} // dw
} // internal
} // nw
