﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dev/dev_DevTextWriter.h>

namespace nw {
namespace internal {
namespace dw {

struct DrawTextArgs;

class NwTextRenderer
{
public:
    /* ctor */ NwTextRenderer();

public:
    bool Initialize(
        nw::ut::IAllocator& allocator,
        void* pFontBinary,
        u32 fontBinarySize,
        void* pShaderBinary,
        u32 shaderBinarySize);
    void Finalize();

    void SetProjectionMatrix(const nw::math::Matrix44& matrix);
    void SetViewMatrix(const nw::math::Matrix34& matrix);

    f32 GetGlobalScale() const { return m_GlobalScale; }
    void SetGlobalScale(f32 scale) { m_GlobalScale = scale; }

    void DrawText(const DrawTextArgs& arg, const char* pText);
    void DrawTextFormat(const DrawTextArgs& arg, const char* pFormat, ...);
    void VDrawTextFormat(const DrawTextArgs& arg, const char* pFormat, va_list valist);
    nw::math::Vector2 MeasureText(const DrawTextArgs& arg, const char* pText);
    nw::math::Vector2 MeasureTextFormat(const DrawTextArgs& arg, const char* pFormat, ...);
    nw::math::Vector2 VMeasureTextFormat(const DrawTextArgs& arg, const char* pFormat, va_list valist);

    void Clear();
    void Flush();

public:
    nw::dev::DevTextWriter m_TextWriter;
    nw::math::Matrix44 m_ProjectionMatrix;
    nw::math::Matrix34 m_ViewMatrix;
    f32 m_GlobalScale;
};

} // dw
} // internal
} // nw
