﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DW_INPUT_SETTINGS_H_
#define NW_DW_INPUT_SETTINGS_H_

#include <nw/dev.h>

namespace nw {
namespace internal {
namespace dw {

class InputSettings
{
public:
    class WindowManagerSetting
    {
    public:
        WindowManagerSetting()
        : m_WindowControlModifier(nw::dev::Pad::MASK_R)
        {
        }

    public:
        void SetWindowControlModifier(u32 modifier) { m_WindowControlModifier = modifier; }
        u32 GetWindowControlModifier() const { return m_WindowControlModifier; }

    private:
        u32 m_WindowControlModifier;
    };

public:
    static InputSettings& GetInstance();

public:
    WindowManagerSetting& GetWindowManagerSetting() { return m_WindowManagerSetting; }
    const WindowManagerSetting& GetWindowManagerSetting() const { return m_WindowManagerSetting; }

private:
    InputSettings()
    : m_WindowManagerSetting()
    {
    }

private:
    static InputSettings s_Instance;

    WindowManagerSetting m_WindowManagerSetting;
};

} // namespace dw
} // namespace internal
} // namespace nw

#endif // NW_DW_INPUT_SETTINGS_H_
