﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// nw
#include <nw/ut.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief ファイルを読み込むためのユーティリティクラスです。
//---------------------------------------------------------------------------
class FileLoader
{
    NW_DISALLOW_COPY_AND_ASSIGN(FileLoader);

private:
    // ファイルアクセス用の最小アライメント
#if defined(NW_PLATFORM_CAFE)
    static const int BUFFER_MIN_ALIGNMENT = 64;
#else
    static const int BUFFER_MIN_ALIGNMENT = 32;
    typedef ::nw::internal::winext::FSClient FSClient;
    typedef ::nw::internal::winext::FSCmdBlock FSCmdBlock;
#endif

public:
    FileLoader(FSClient* fsClient, FSCmdBlock* fsCmdBlock, nw::ut::IAllocator& allocator, bool isAutoFree=true);
    virtual ~FileLoader();

public:
    bool Open(const char* pFileName, u32 alignment=0);
    void Close();

    void* GetData() const;
    u32 GetDataSize() const;

private:
    FSClient* m_fsClient;
    FSCmdBlock* m_fsCmdBlock;
    nw::ut::IAllocator& m_Allocator;

    bool m_isAutoFree;
    void* m_pData;
    u32 m_DataSize;
};

} // nw::internal::dw
} // nw::internal
} // nw
