﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/math.h>
#include <nw/ut/ut_Color.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief テキスト描画のパラメータです。
//---------------------------------------------------------------------------
struct DrawTextArgs
{
    DrawTextArgs();

    DrawTextArgs& SetTopLeft(float x, float y);
    DrawTextArgs& SetTopLeft(const nw::math::Vector2& value);
    DrawTextArgs& SetScale(float value);
    DrawTextArgs& SetColor(float r, float g, float b, float a);
    DrawTextArgs& SetColor(const nw::ut::Color4f& value);
    DrawTextArgs& Offset(float x, float y);
    DrawTextArgs& Offset(const nw::math::Vector2& value);

    nw::math::Vector2 topLeft;
    f32 scale;
    nw::ut::Color4f color;
};

} // dw
} // internal
} // nw
