﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/math.h>
#include <nw/ut/ut_Color.h>
#include <nw/gfnd.h>
#include <nw/dw/system/dw_Types.h>
#include <nw/ut/ut_Inlines.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief 矩形描画のパラメータです。
//---------------------------------------------------------------------------
struct DrawRectangleArgs
{
    DrawRectangleArgs() :
        colorOrientation(VERTICAL),
        texture(NULL)
    { }

    //---------------------------------------------------------------------------

    DrawRectangleArgs& SetTopLeft(float x, float y)
    {
        topLeft.x = x;
        topLeft.y = y;
        return *this;
    }

    DrawRectangleArgs& SetTopLeft(const nw::math::Vector2& value)
    {
        topLeft = value;
        return *this;
    }

    DrawRectangleArgs& SetSize(float x, float y)
    {
        size.x = x;
        size.y = y;
        return *this;
    }

    DrawRectangleArgs& SetSize(const nw::math::Vector2& value)
    {
        size = value;
        return *this;
    }

    DrawRectangleArgs& SetColor(float r, float g, float b, float a)
    {
        SetColor0(r, g, b, a);
        SetColor1(r, g, b, a);
        return *this;
    }

    DrawRectangleArgs& SetColor(const nw::ut::Color4f& value)
    {
        SetColor0(value);
        SetColor1(value);
        return *this;
    }

    DrawRectangleArgs& SetColor(const nw::ut::Color4f& value0, const nw::ut::Color4f& value1)
    {
        SetColor0(value0);
        SetColor1(value1);
        return *this;
    }

    DrawRectangleArgs& SetColor0(float r, float g, float b, float a)
    {
        color0.r = r;
        color0.g = g;
        color0.b = b;
        color0.a = a;
        return *this;
    }

    DrawRectangleArgs& SetColor0(const nw::ut::Color4f& value)
    {
        color0 = value;
        return *this;
    }

    DrawRectangleArgs& SetColor1(float r, float g, float b, float a)
    {
        color1.r = r;
        color1.g = g;
        color1.b = b;
        color1.a = a;
        return *this;
    }

    DrawRectangleArgs& SetColor1(const nw::ut::Color4f& value)
    {
        color1 = value;
        return *this;
    }

    DrawRectangleArgs& SetColorOrientation(Orientation value)
    {
        colorOrientation = value;
        return *this;
    }

    DrawRectangleArgs& SetTexture(nw::gfnd::Texture* value)
    {
        texture = value;
        return *this;
    }

    DrawRectangleArgs& Offset(float x, float y)
    {
        topLeft.x += x;
        topLeft.y += y;
        return *this;
    }

    DrawRectangleArgs& Offset(const nw::math::Vector2& value)
    {
        topLeft += value;
        return *this;
    }

    bool IsSizeZero() const
    {
        return ((size.x < 0.f || nw::ut::FloatEquals(size.x, 0.f)) &&
            (size.y < 0.f || nw::ut::FloatEquals(size.y, 0.f)));
    }

    //---------------------------------------------------------------------------

    nw::math::Vector2 topLeft;
    nw::math::Vector2 size;
    nw::ut::Color4f color0;
    nw::ut::Color4f color1;
    Orientation colorOrientation;
    nw::gfnd::Texture* texture;
};

} // dw
} // internal
} // nw
