﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/math.h>
#include <nw/dev.h>
#include <nw/ut/ut_Color.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief ライン描画のパラメータです。
//---------------------------------------------------------------------------
struct DrawLineArgs
{
    DrawLineArgs()
      : lineWidth(1.f) {}

    DrawLineArgs& SetFrom(float x, float y);
    DrawLineArgs& SetFrom(const nw::math::Vector2& value);
    DrawLineArgs& SetTo(float x, float y);
    DrawLineArgs& SetTo(const nw::math::Vector2& value);
    DrawLineArgs& SetColor(const nw::ut::Color4f& value);
    DrawLineArgs& SetColor(const nw::ut::Color4f& color0, const nw::ut::Color4f& color1);
    DrawLineArgs& SetColor0(float r, float g, float b, float a);
    DrawLineArgs& SetColor0(const nw::ut::Color4f& value);
    DrawLineArgs& SetColor1(float r, float g, float b, float a);
    DrawLineArgs& SetColor1(const nw::ut::Color4f& value);
    DrawLineArgs& SetLineWidth(float width);
    DrawLineArgs& Offset(float x, float y);
    DrawLineArgs& Offset(const nw::math::Vector2& value);

    nw::math::Vector2 from;
    nw::math::Vector2 to;
    nw::ut::Color4f color0;
    nw::ut::Color4f color1;
    f32 lineWidth;
};

#if defined(_WIN32)
#pragma warning(push)
#pragma warning(disable:4512)
#endif
struct DrawMultiLineArgs
{
    /* implicit */ DrawMultiLineArgs(const nw::dev::DrawBuffer& _buffer)
      : buffer(_buffer)
      , lineWidth(1.f){}

    /* implicit */ DrawMultiLineArgs(const DrawMultiLineArgs& source)
        : buffer(source.buffer)
        , color(source.color)
        , lineWidth(source.lineWidth){}

    DrawMultiLineArgs& SetColor(const nw::ut::Color4f& value);
    DrawMultiLineArgs& SetLineWidth(float width);

    const nw::dev::DrawBuffer& buffer;
    nw::ut::Color4f color;
    f32 lineWidth;
};
#if defined(_WIN32)
#pragma warning(pop)
#endif

} // dw
} // internal
} // nw
