﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut/ut_Delegate.h>
#include <nw/dw/control/dw_UIElementListEventArgs.h>

namespace nw {
namespace internal {
namespace dw {

class UIElement;

class UIElementList
{
public:
    virtual ~UIElementList() {}
    static const s32 INVALID_INDEX = -1;

    typedef ut::DelegateEvent1<UIElementListEventArgs&> ItemsChangedEvent;
    typedef ItemsChangedEvent::Slot ItemsChangedEventHandler;

public:
    virtual s32 GetCount() const = 0;
    virtual UIElement* GetItem(s32 index) const = 0;
    virtual bool AddItem(UIElement* pItem) = 0;
    virtual bool InsertItem(s32 index, UIElement* pItem) = 0;
    virtual bool SetItem(s32 index, UIElement* pItem) = 0;
    virtual bool AddItems(UIElement* const* ppItems, s32 count) = 0;
    virtual bool SetItems(s32 index, UIElement* const* ppItems, s32 count) = 0;
    virtual bool ClearItems() = 0;
    virtual s32 IndexOf(const UIElement* pItem) const = 0;

    virtual UIElement* operator [] (s32 index) const = 0;

    virtual ItemsChangedEvent& GetItemsChangedEvent() = 0;
};

} // dw
} // internal
} // nw
