﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief UI要素のスタイルを示します。
//---------------------------------------------------------------------------
template<class TUIElement>
class StyleT
{
public:
    virtual ~StyleT() {}
    /*override*/ bool CanApply(UIElement& element);
    /*override*/ void Apply(UIElement& element);

protected:
    virtual bool CanApplyInternal(TUIElement& element) = 0;
    virtual void ApplyInternal(TUIElement& element) = 0;
};

} // dw
} // internal
} // nw

#include "StyleT.hpp"
